/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.management.agent.JmxDomainAgent;
import org.mule.tck.junit4.DomainFunctionalTestCase;

public class SharedResourcesWithJmxAgentTestCase
extends DomainFunctionalTestCase {
    public static final String APP1 = "App1";
    public static final String APP2 = "App2";
    public static final String ENDPOINT_JMS_QUEUE_APP1 = "endpoint.jms.queueApp1";
    public static final String ENDPOINT_JMS_QUEUE_APP2 = "endpoint.jms.queueApp2";
    public static final String FLOW_APP1 = "flowApp1";
    public static final String FLOW_APP2 = "flowApp2";
    public static final String TYPE_ENDPOINT = "type=Endpoint";

    protected String getDomainConfig() {
        return "domain/jms-shared-connector.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, APP1, new String[]{"jmx-app-1.xml"}), new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, APP2, new String[]{"jmx-app-2.xml"})};
    }

    @Test
    public void testDomainAndAppsAgentsCreation() throws Exception {
        JmxDomainAgent jmxAgent = (JmxDomainAgent)this.getMuleContextForDomain().getRegistry().lookupObject(JmxDomainAgent.class);
        MBeanServer mBeanServer = jmxAgent.getMBeanServer();
        Set<ObjectName> objectNames = mBeanServer.queryNames(null, null);
        Assert.assertEquals((long)1L, (long)this.getNamesCount(objectNames, ENDPOINT_JMS_QUEUE_APP1));
        Assert.assertEquals((long)1L, (long)this.getNamesCount(objectNames, ENDPOINT_JMS_QUEUE_APP1, FLOW_APP1));
        Assert.assertEquals((long)1L, (long)this.getNamesCount(objectNames, ENDPOINT_JMS_QUEUE_APP2));
        Assert.assertEquals((long)1L, (long)this.getNamesCount(objectNames, ENDPOINT_JMS_QUEUE_APP2, FLOW_APP2));
        Assert.assertEquals((long)1L, (long)this.getNamesCount(objectNames, FLOW_APP1, TYPE_ENDPOINT));
        Assert.assertEquals((long)1L, (long)this.getNamesCount(objectNames, FLOW_APP2, TYPE_ENDPOINT));
    }

    private int getNamesCount(Set<ObjectName> objectNames, String ... filters) {
        ArrayList<String> names = new ArrayList<String>();
        for (ObjectName objectName : objectNames) {
            String canonicalName = objectName.getCanonicalName();
            if (!this.containsAll(canonicalName, filters)) continue;
            names.add(canonicalName);
        }
        return names.size();
    }

    private boolean containsAll(String text, String ... filters) {
        for (String filter : filters) {
            if (text.contains(filter)) continue;
            return false;
        }
        return true;
    }
}

