/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.functional;

import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class SimpleXmlTransformerFunctionalTestCase
extends FunctionalTestCase {
    public static final String SERIALIZED = "<org.mule.module.xml.functional.SimpleXmlTransformerFunctionalTestCase_-Parent>\n  <child>\n    <name>theChild</name>\n  </child>\n</org.mule.module.xml.functional.SimpleXmlTransformerFunctionalTestCase_-Parent>";

    protected String getConfigFile() {
        return "org/mule/module/xml/simple-xml-transformer-functional-test-flow.xml";
    }

    @Ignore(value="flaky test")
    @Test
    public void testXmlOut() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("xml-in", (Object)SERIALIZED, null);
        Parent parent = (Parent)this.request((MuleClient)client, "xml-object-out", Parent.class);
        Assert.assertNotNull((Object)parent);
        Assert.assertNotNull((Object)parent.getChild());
        Assert.assertEquals((Object)"theChild", (Object)parent.getChild().getName());
    }

    @Test
    public void testObjectXmlOut() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("object-in", (Object)new Parent(new Child("theChild")), null);
        String xml = (String)this.request((MuleClient)client, "object-xml-out", String.class);
        XMLAssert.assertXMLEqual((String)SERIALIZED, (String)xml);
    }

    protected Object request(MuleClient client, String endpoint, Class<?> clazz) throws MuleException {
        MuleMessage message = client.request(endpoint, 3000L);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getPayload());
        Assert.assertTrue((String)message.getPayload().getClass().getName(), (boolean)clazz.isAssignableFrom(message.getPayload().getClass()));
        return message.getPayload();
    }

    public static class Child {
        private String name;

        public Child() {
            this(null);
        }

        public Child(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Parent {
        private Child child;

        public Parent() {
            this(null);
        }

        public Parent(Child child) {
            this.setChild(child);
        }

        public Child getChild() {
            return this.child;
        }

        public void setChild(Child child) {
            this.child = child;
        }
    }
}

