/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.store.ObjectStoreException;
import org.mule.exception.AbstractExceptionListener;
import org.mule.processor.AbstractFilteringMessageProcessor;
import org.mule.routing.AggregationException;
import org.mule.routing.EventGroup;
import org.mule.routing.SimpleCollectionAggregator;
import org.mule.routing.correlation.CollectionCorrelatorCallback;
import org.mule.routing.correlation.CorrelationTimeoutException;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class AggregationTestCase
extends FunctionalTestCase {
    private static Latch timeoutLatch;

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/aggregation-config.xml";
    }

    @Test
    public void testCollectionAggregationTimeout() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String payload = "Long string that wil be broken uop into multiple messages";
        client.dispatch("vm://inTimeout", (Object)payload, null);
        client.request("vm://collectionCreated2", 5000L);
        MatcherAssert.assertThat((Object)TestExceptionStrategy.exception, (Matcher)CoreMatchers.instanceOf(CorrelationTimeoutException.class));
        MatcherAssert.assertThat((Object)TestExceptionStrategy.event, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(VoidMuleEvent.class)));
    }

    @Test
    public void testCollectionAggregator() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String payload = "Long string that wil be broken uop into multiple messages";
        client.dispatch("vm://in", (Object)payload, null);
        MuleMessage msg = client.request("vm://collectionCreated", 5000L);
        MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.instanceOf(MuleMessageCollection.class));
        MuleMessageCollection collection = (MuleMessageCollection)msg;
        List chunks = (List)collection.getPayload();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] chunk : chunks) {
            baos.write(chunk);
        }
        String aggregated = baos.toString();
        MatcherAssert.assertThat((Object)payload, (Matcher)CoreMatchers.equalTo((Object)aggregated));
    }

    @Test
    public void testCustomAggregator() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String payload = "Long string that wil be broken uop into multiple messages";
        client.dispatch("vm://in2", (Object)payload, null);
        MuleMessage msg = client.request("vm://collectionCreated2", 5000L);
        MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)msg.getPayload(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)msg.getPayload(), (Matcher)CoreMatchers.instanceOf(List.class));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Object obj : (List)msg.getPayload()) {
            MatcherAssert.assertThat(obj, (Matcher)CoreMatchers.instanceOf(MuleEvent.class));
            MuleEvent event = (MuleEvent)obj;
            MatcherAssert.assertThat((Object)event.getMessage().getPayload(), (Matcher)CoreMatchers.instanceOf(byte[].class));
            baos.write((byte[])event.getMessage().getPayload());
        }
        String aggregated = baos.toString();
        MatcherAssert.assertThat((Object)payload, (Matcher)CoreMatchers.equalTo((Object)aggregated));
    }

    public static class TestExceptionStrategy
    extends AbstractExceptionListener
    implements MessagingExceptionHandler,
    SystemExceptionHandler {
        public static Exception exception;
        public static MuleEvent event;

        public void handleException(Exception exception, RollbackSourceCallback rollbackMethod) {
            TestExceptionStrategy.exception = exception;
        }

        public void handleException(Exception exception) {
            TestExceptionStrategy.exception = exception;
        }

        public MuleEvent handleException(Exception exception, MuleEvent event) {
            TestExceptionStrategy.event = event;
            TestExceptionStrategy.exception = exception;
            timeoutLatch.countDown();
            return event;
        }
    }

    static class MyCollectionCorrelatorCallback
    extends CollectionCorrelatorCallback {
        public MyCollectionCorrelatorCallback(MuleContext muleContext, boolean persistentStores, String storePrefix) {
            super(muleContext, storePrefix);
        }

        public MuleEvent aggregateEvents(EventGroup events) throws AggregationException {
            ArrayList<MuleEvent> eventList = new ArrayList<MuleEvent>();
            Iterator iter = null;
            FlowConstruct fc = null;
            try {
                iter = events.iterator(true);
            }
            catch (ObjectStoreException e) {
                throw new AggregationException(events, null, (Throwable)e);
            }
            while (iter.hasNext()) {
                MuleEvent event = (MuleEvent)iter.next();
                eventList.add(event);
                fc = event.getFlowConstruct();
            }
            DefaultMuleMessage msg = new DefaultMuleMessage(eventList, this.muleContext);
            return new DefaultMuleEvent((MuleMessage)msg, MessageExchangePattern.ONE_WAY, fc);
        }
    }

    static class WaitTillTimeoutProcessor
    extends AbstractFilteringMessageProcessor {
        WaitTillTimeoutProcessor() {
        }

        protected boolean accept(MuleEvent event) {
            try {
                if (timeoutLatch == null) {
                    timeoutLatch = new Latch();
                } else {
                    timeoutLatch.await();
                }
            }
            catch (InterruptedException e) {
                this.logger.warn((Object)"The thread was interrupted.");
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
    }

    public static class Aggregator
    extends SimpleCollectionAggregator {
        protected EventCorrelatorCallback getCorrelatorCallback(MuleContext context) {
            return new MyCollectionCorrelatorCallback(context, this.persistentStores, this.storePrefix);
        }
    }
}

