/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.RoutingException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.EventCorrelator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.lock.LockFactory;

public class EventCorrelatorTestCase
extends AbstractMuleTestCase {
    private EventCorrelator eventCorrelator;
    private final EventCorrelatorCallback eventCorrelatorCallback = (EventCorrelatorCallback)Mockito.mock(EventCorrelatorCallback.class);
    private final MessageProcessor messageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
    private final MessageInfoMapping messageInfoMapping = (MessageInfoMapping)Mockito.mock(MessageInfoMapping.class);
    private final FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
    private final MuleMessage muleMessage = (MuleMessage)Mockito.mock(DefaultMuleMessage.class);
    private PartitionableObjectStore<EventGroup> partitionableObjectStore = (PartitionableObjectStore)Mockito.mock(PartitionableObjectStore.class);
    private ObjectStore<Long> objectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
    private MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
    private EventGroup eventGroup = (EventGroup)Mockito.mock(EventGroup.class);
    private LockFactory lockFactory = (LockFactory)Mockito.mock(LockFactory.class);
    private Lock lock = new ReentrantLock();
    private int countOfEventGroups = 0;
    private boolean eventGroupWasSaved = false;

    @Before
    public void setUp() throws Exception {
        this.setReturnsAndExceptions();
        this.setAnswers();
        Mockito.when((Object)this.lockFactory.createLock((String)org.mockito.Matchers.any(String.class))).thenReturn((Object)this.lock);
        Mockito.when((Object)this.muleContext.getLockFactory()).thenReturn((Object)this.lockFactory);
        this.eventCorrelator = new EventCorrelator(this.eventCorrelatorCallback, this.messageProcessor, this.messageInfoMapping, this.muleContext, this.flowConstruct, this.partitionableObjectStore, "prefix", this.objectStore);
    }

    @Test
    public void testEventGroupFreedInRoutingException() throws Exception {
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)this.muleMessage);
        try {
            this.eventCorrelator.process(event);
            Assert.fail((String)"Routing Exception must be catched.");
        }
        catch (RoutingException e) {
            Assert.assertTrue((String)"Event Group wasn't saved", (boolean)this.eventGroupWasSaved);
            Assert.assertThat((Object)this.countOfEventGroups, (Matcher)Matchers.is((Object)0));
        }
    }

    private void setReturnsAndExceptions() throws Exception {
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
        Mockito.when((Object)this.messageInfoMapping.getCorrelationId((MuleMessage)org.mockito.Matchers.any(MuleMessage.class))).thenReturn((Object)"id");
        Mockito.when((Object)this.partitionableObjectStore.retrieve((Serializable)org.mockito.Matchers.any(Serializable.class), (String)org.mockito.Matchers.any(String.class))).thenThrow(new Class[]{ObjectDoesNotExistException.class});
        Mockito.when((Object)this.eventCorrelatorCallback.createEventGroup((MuleEvent)org.mockito.Matchers.any(MuleEvent.class), org.mockito.Matchers.any(Object.class))).thenReturn((Object)this.eventGroup);
        Mockito.when((Object)this.eventCorrelatorCallback.aggregateEvents((EventGroup)org.mockito.Matchers.any(EventGroup.class))).thenThrow(new Class[]{RoutingException.class});
        Mockito.when((Object)this.eventCorrelatorCallback.shouldAggregateEvents((EventGroup)org.mockito.Matchers.any(EventGroup.class))).thenReturn((Object)true);
    }

    private void setAnswers() throws ObjectStoreException {
        ((PartitionableObjectStore)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                EventCorrelatorTestCase.this.countOfEventGroups++;
                EventCorrelatorTestCase.this.eventGroupWasSaved = true;
                return null;
            }
        }).when(this.partitionableObjectStore)).store((Serializable)org.mockito.Matchers.any(Serializable.class), (Serializable)org.mockito.Matchers.any(EventGroup.class), (String)org.mockito.Matchers.any(String.class));
        ((PartitionableObjectStore)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                EventCorrelatorTestCase.this.countOfEventGroups--;
                return null;
            }
        }).when(this.partitionableObjectStore)).remove((Serializable)org.mockito.Matchers.any(Serializable.class), (String)org.mockito.Matchers.any(String.class));
    }
}

