/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.junit4.DomainFunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class ShutdownAppInDomainTestCase
extends DomainFunctionalTestCase {
    private static final int PROBER_POLLING_INTERVAL = 100;
    private static final int PROBER_POLIING_TIMEOUT = 5000;
    private static final int MESSAGE_TIMEOUT = 2000;
    private static final Set<PhantomReference<MuleEvent>> requestContextRefs = new HashSet<PhantomReference<MuleEvent>>();
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    @Before
    public void before() {
        requestContextRefs.clear();
    }

    protected String getDomainConfig() {
        return "org/mule/shutdown/domain-with-connectors.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, "app-with-flows", new String[]{"org/mule/shutdown/app-with-flows.xml"})};
    }

    @Test
    public void httpListener() throws MuleException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        muleContextForApp.getClient().request("http://localhost:" + this.httpPort.getNumber() + "/sync", 2000L);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    public void httpListenerNonBlocking() throws MuleException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        muleContextForApp.getClient().request("http://localhost:" + this.httpPort.getNumber() + "/nonBlocking", 2000L);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    public void httpRequest() throws MuleException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        muleContextForApp.getClient().request("http://localhost:" + this.httpPort.getNumber() + "/request", 2000L);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    @Test
    public void jms() throws MuleException {
        MuleContext muleContextForApp = this.getMuleContextForApp("app-with-flows");
        muleContextForApp.getClient().dispatch("jms://in?connector=sharedJmsConnector", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContextForApp));
        muleContextForApp.getClient().request("jms://out?connector=sharedJmsConnector", 2000L);
        muleContextForApp.dispose();
        this.assertEventsUnreferenced();
    }

    private void assertEventsUnreferenced() {
        new PollingProber(5000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                System.gc();
                for (PhantomReference phantomReference : requestContextRefs) {
                    Assert.assertThat((Object)phantomReference.isEnqueued(), (Matcher)CoreMatchers.is((Object)true));
                }
                return true;
            }
        });
    }

    public static class RetrieveRequestContext
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            requestContextRefs.add(new PhantomReference<MuleEvent>(RequestContext.getEvent(), new ReferenceQueue()));
            return event;
        }
    }
}

