/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ObjectStore;
import org.mule.construct.Flow;
import org.mule.lifecycle.LifecycleTrackerProcessor;
import org.mule.processor.chain.SubflowInterceptingChainLifecycleWrapper;
import org.mule.routing.IdempotentMessageFilter;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.SystemUtils;
import org.mule.util.store.InMemoryObjectStore;
import org.mule.util.store.SimpleMemoryObjectStore;
import org.mule.util.store.TextFileObjectStore;

public class IdempotentMessageFilterNamespaceHandlerTestCase
extends FunctionalTestCase {
    public IdempotentMessageFilterNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "org/mule/test/config/idempotent-message-filter-config.xml";
    }

    @Test
    public void testInMemoryObjectStore() throws Exception {
        IdempotentMessageFilter filter = this.idempotentMessageFilterFromFlow("inMemoryStore");
        ObjectStore store = filter.getStore();
        Assert.assertEquals(InMemoryObjectStore.class, store.getClass());
        InMemoryObjectStore memoryStore = (InMemoryObjectStore)store;
        Assert.assertEquals((long)1000L, (long)memoryStore.getEntryTTL());
        Assert.assertEquals((long)2000L, (long)memoryStore.getExpirationInterval());
        Assert.assertEquals((long)3000L, (long)memoryStore.getMaxEntries());
    }

    @Test
    public void testSimpleTextFileStore() throws Exception {
        IdempotentMessageFilter filter = this.idempotentMessageFilterFromFlow("simpleTextFileStore");
        ObjectStore store = filter.getStore();
        Assert.assertEquals(TextFileObjectStore.class, store.getClass());
        TextFileObjectStore fileStore = (TextFileObjectStore)store;
        Assert.assertEquals((Object)"the-store", (Object)fileStore.getName());
        File tmpDir = SystemUtils.getJavaIoTmpDir();
        Assert.assertEquals((Object)tmpDir.getCanonicalPath(), (Object)new File(fileStore.getDirectory()).getCanonicalPath());
        Assert.assertEquals((long)1000L, (long)fileStore.getEntryTTL());
        Assert.assertEquals((long)2000L, (long)fileStore.getExpirationInterval());
        Assert.assertEquals((long)3000L, (long)fileStore.getMaxEntries());
    }

    @Test
    public void testCustomObjectStore() throws Exception {
        this.testPojoObjectStore("customObjectStore");
    }

    @Test
    public void testOnUnaccepted() throws Exception {
        IdempotentMessageFilter filter = this.idempotentMessageFilterFromFlow("idempotentFilterWithOnUnacceptedMP");
        Assert.assertNotNull((Object)filter.getUnacceptedMessageProcessor());
        Assert.assertEquals(StringAppendTransformer.class, filter.getUnacceptedMessageProcessor().getClass());
    }

    @Test
    public void testInitialisesOnUnacceptedSubFlow() throws Exception {
        IdempotentMessageFilter filter = this.idempotentMessageFilterFromFlow("idempotentFilterWithOnUnacceptedMPToSubFlow");
        Assert.assertNotNull((Object)filter.getUnacceptedMessageProcessor());
        SubflowInterceptingChainLifecycleWrapper subflow = (SubflowInterceptingChainLifecycleWrapper)filter.getUnacceptedMessageProcessor();
        LifecycleTrackerProcessor lifecycleTrackerProcessor = (LifecycleTrackerProcessor)subflow.getMessageProcessors().get(0);
        Assert.assertTrue((boolean)lifecycleTrackerProcessor.getTracker().contains("initialise"));
    }

    public void testBeanObjectStore() throws Exception {
        this.testPojoObjectStore("beanObjectStore");
    }

    private void testPojoObjectStore(String flowName) throws Exception {
        IdempotentMessageFilter filter = this.idempotentMessageFilterFromFlow(flowName);
        ObjectStore store = filter.getStore();
        Assert.assertEquals(CustomObjectStore.class, store.getClass());
        CustomObjectStore customStore = (CustomObjectStore)store;
        Assert.assertEquals((Object)("the-value:" + flowName), (Object)customStore.getCustomProperty());
    }

    private IdempotentMessageFilter idempotentMessageFilterFromFlow(String flowName) throws Exception {
        FlowConstruct flow = this.getFlowConstruct(flowName);
        Assert.assertTrue((boolean)(flow instanceof Flow));
        Flow simpleFlow = (Flow)flow;
        List processors = simpleFlow.getMessageProcessors();
        Assert.assertEquals((long)1L, (long)processors.size());
        MessageProcessor firstMP = (MessageProcessor)processors.get(0);
        Assert.assertEquals(IdempotentMessageFilter.class, firstMP.getClass());
        return (IdempotentMessageFilter)firstMP;
    }

    public static class CustomObjectStore
    extends SimpleMemoryObjectStore<Serializable> {
        private String customProperty;

        public String getCustomProperty() {
            return this.customProperty;
        }

        public void setCustomProperty(String value) {
            this.customProperty = value;
        }
    }
}

