/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import org.junit.Assert;
import org.junit.Test;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.vm.VMMessageDispatcher;
import org.mule.transport.vm.VMMessageDispatcherFactory;
import org.mule.transport.vm.VMMessageReceiver;

public class FlowDefaultProcessingStrategyTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/construct/flow-default-processing-strategy-config.xml";
    }

    @Test
    public void testDispatchToOneWayInbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://oneway-in", (Object)"a", null);
        MuleMessage result = client.request("vm://oneway-out", 5000L);
        this.assertAllProcessingAsync(result);
    }

    @Test
    public void testSendToOneWayInbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://oneway-in", (Object)"a", null);
        Assert.assertNull((Object)response);
        MuleMessage result = client.request("vm://oneway-out", 5000L);
        Assert.assertNotNull((Object)result);
        String receiverThread = (String)result.getInboundProperty("receiver-thread");
        String flowThread = (String)result.getInboundProperty("processor-thread");
        String dispatcherThread = (String)result.getInboundProperty("dispatcher-thread");
        Assert.assertEquals((Object)Thread.currentThread().getName(), (Object)receiverThread);
        Assert.assertFalse((boolean)receiverThread.equals(flowThread));
        Assert.assertFalse((boolean)flowThread.equals(dispatcherThread));
    }

    @Test
    public void testDispatchToOneWayTx() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://oneway-tx-in", (Object)"a", null);
        MuleMessage result = client.request("vm://oneway-tx-out", 5000L);
        this.assertAllProcessingInRecieverThread(result);
    }

    @Test
    public void testSendToOneWayTx() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://oneway-tx-in", (Object)"a", null);
        Assert.assertNull((Object)response);
        MuleMessage result = client.request("vm://oneway-tx-out", 5000L);
        this.assertAllProcessingInClientThread(result);
    }

    @Test
    public void testDispatchToOneWayInboundTxOnly() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://oneway-inboundtx-in", (Object)"a", null);
        MuleMessage result = client.request("vm://oneway-inboundtx-out", 5000L);
        this.assertAllProcessingInRecieverThread(result);
    }

    @Test
    public void testDispatchToOneWayOutboundTxOnly() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://oneway-outboundtx-in", (Object)"a", null);
        MuleMessage result = client.request("vm://oneway-outboundtx-out", 5000L);
        this.assertAllProcessingAsync(result);
    }

    @Test
    public void testSendRequestResponseInbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://requestresponse-in", (Object)"a", null);
        this.assertAllProcessingInClientThread(response);
    }

    @Test
    public void testDispatchToRequestResponseInboundOneWayOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://requestresponse-oneway-in", (Object)"a", null);
        Assert.assertNull((Object)client.request("vm://requestresponse-oneway-out", 5000L));
    }

    @Test
    public void testSendToRequestResponseInboundOneWayOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://requestresponse-oneway-in", (Object)"a", null);
        Assert.assertEquals((Object)"a", (Object)response.getPayload());
        MuleMessage result = client.request("vm://requestresponse-oneway-out", 5000L);
        this.assertAllProcessingInClientThread(result);
    }

    protected void assertAllProcessingInClientThread(MuleMessage result) {
        this.assertSync(result);
        Assert.assertEquals((Object)Thread.currentThread().getName(), (Object)result.getInboundProperty("receiver-thread"));
    }

    protected void assertAllProcessingInRecieverThread(MuleMessage result) {
        this.assertSync(result);
        Assert.assertTrue((boolean)((String)result.getInboundProperty("receiver-thread")).startsWith("vm.receiver"));
    }

    protected void assertSync(MuleMessage result) {
        Assert.assertNotNull((Object)result);
        String receiverThread = (String)result.getInboundProperty("receiver-thread");
        String flowThread = (String)result.getInboundProperty("processor-thread");
        String dispatcherThread = (String)result.getInboundProperty("dispatcher-thread");
        Assert.assertEquals((Object)receiverThread, (Object)flowThread);
        Assert.assertEquals((Object)flowThread, (Object)dispatcherThread);
    }

    protected void assertAllProcessingAsync(MuleMessage result) {
        Assert.assertNotNull((Object)result);
        String receiverThread = (String)result.getInboundProperty("receiver-thread");
        String flowThread = (String)result.getInboundProperty("processor-thread");
        String dispatcherThread = (String)result.getInboundProperty("dispatcher-thread");
        Assert.assertTrue((boolean)receiverThread.startsWith("vm.receiver"));
        Assert.assertFalse((boolean)receiverThread.equals(flowThread));
        Assert.assertFalse((boolean)flowThread.equals(dispatcherThread));
        Assert.assertFalse((boolean)receiverThread.equals(dispatcherThread));
    }

    @Test
    public void testRequestResponseInboundFailingOneWayOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        try {
            MuleMessage response = client.send("vm://requestresponse-failingoneway-in", (Object)"a", null);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ThreadSensingVMMessageReceiver
    extends VMMessageReceiver {
        public ThreadSensingVMMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
            super(connector, flowConstruct, endpoint);
        }

        public MuleMessage onCall(MuleMessage message) throws MuleException {
            try {
                message.setOutboundProperty("receiver-thread", (Object)Thread.currentThread().getName());
                MuleEvent event = this.routeMessage(message);
                MuleMessage returnedMessage = !this.endpoint.getExchangePattern().hasResponse() || event == null || VoidMuleEvent.getInstance().equals(event) ? null : event.getMessage();
                return returnedMessage;
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }

        protected MuleEvent processMessage(Object msg) throws Exception {
            MuleMessage message = (MuleMessage)msg;
            MuleMessage newMessage = message.createInboundMessage();
            newMessage.setOutboundProperty("receiver-thread", (Object)Thread.currentThread().getName());
            return this.routeMessage(newMessage);
        }
    }

    public static class ThreadSensingVMMessageDispatcher
    extends VMMessageDispatcher {
        public ThreadSensingVMMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        protected void doDispatch(MuleEvent event) throws Exception {
            event.getMessage().setOutboundProperty("dispatcher-thread", (Object)Thread.currentThread().getName());
            super.doDispatch(event);
        }

        protected MuleMessage doSend(MuleEvent event) throws Exception {
            event.getMessage().setOutboundProperty("dispatcher-thread", (Object)Thread.currentThread().getName());
            return super.doSend(event);
        }
    }

    public static class ThreadSensingVMMessageDispatcherFactory
    extends VMMessageDispatcherFactory {
        public MessageDispatcher create(OutboundEndpoint endpoint) throws MuleException {
            return new ThreadSensingVMMessageDispatcher(endpoint);
        }
    }

    public static class ThreadSensingMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            event.getMessage().setOutboundProperty("processor-thread", (Object)Thread.currentThread().getName());
            return event;
        }
    }
}

