/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.tck.SensingNullRequestResponseMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class FlowRefTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private static String FLOW1_SENSING_PROCESSOR_NAME = "NonBlockingFlow1SensingProcessor";
    private static String FLOW2_SENSING_PROCESSOR_NAME = "NonBlockingFlow2SensingProcessor";
    private static String TO_QUEUED_ASYNC_FLOW1_SENSING_PROCESSOR_NAME = "NonBlockingToQueuedAsyncFlow1SensingProcessor";
    private static String TO_QUEUED_ASYNC_FLOW2_SENSING_PROCESSOR_NAME = "NonBlockingToQueuedAsyncFlow2SensingProcessor";
    private static String TO_ASYNC_FLOW1_SENSING_PROCESSOR_NAME = "NonBlockingToAsyncFlow1SensingProcessor";
    private static String TO_ASYNC_FLOW2_SENSING_PROCESSOR_NAME = "NonBlockingToAsyncFlow2SensingProcessor";
    private static String TO_SYNC_FLOW1_SENSING_PROCESSOR_NAME = "NonBlockingToSyncFlow1SensingProcessor";
    private static String TO_SYNC_FLOW2_SENSING_PROCESSOR_NAME = "NonBlockingToSyncFlow2SensingProcessor";
    private static String ERROR_MESSAGE = "ERROR";

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-ref.xml";
    }

    @Before
    public void before() {
        ProcessorPathAssertingProcessor.traversedProcessorPaths.clear();
    }

    @Test
    public void twoFlowRefsToSubFlow() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage msg = client.send("vm://two.flow.ref.to.sub.flow", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        Assert.assertEquals((Object)"012xyzabc312xyzabc3", (Object)msg.getPayloadAsString());
    }

    @Test
    public void dynamicFlowRef() throws Exception {
        MuleEvent eventA = FlowRefTestCase.getTestEvent((Object)"0");
        eventA.setFlowVariable("letter", (Object)"A");
        MuleEvent eventB = FlowRefTestCase.getTestEvent((Object)"0");
        eventB.setFlowVariable("letter", (Object)"B");
        Assert.assertEquals((Object)"0A", (Object)((Flow)this.getFlowConstruct("flow2")).process(eventA).getMessageAsString());
        Assert.assertEquals((Object)"0B", (Object)((Flow)this.getFlowConstruct("flow2")).process(eventB).getMessageAsString());
    }

    @Test
    public void dynamicFlowRefProcessorPath() throws Exception {
        MuleEvent eventJ = FlowRefTestCase.getTestEvent((Object)"0");
        eventJ.setFlowVariable("letter", (Object)"J");
        ((Flow)this.getFlowConstruct("flow2")).process(eventJ);
        Assert.assertThat((Object)ProcessorPathAssertingProcessor.traversedProcessorPaths.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat(ProcessorPathAssertingProcessor.traversedProcessorPaths.get(0), (Matcher)Matchers.is((Object)"/flow2/processors/0/sub-flow-J/subprocessors/0"));
    }

    @Test
    public void dynamicFlowRefProcessorPathSameSubflowFromSingleFlow() throws Exception {
        MuleEvent eventJ = FlowRefTestCase.getTestEvent((Object)"0");
        eventJ.setFlowVariable("letter", (Object)"J");
        ((Flow)this.getFlowConstruct("flow3")).process(eventJ);
        Assert.assertThat((Object)ProcessorPathAssertingProcessor.traversedProcessorPaths.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(ProcessorPathAssertingProcessor.traversedProcessorPaths.get(0), (Matcher)Matchers.is((Object)"/flow3/processors/0/sub-flow-J/subprocessors/0"));
        Assert.assertThat(ProcessorPathAssertingProcessor.traversedProcessorPaths.get(1), (Matcher)Matchers.is((Object)"/flow3/processors/1/sub-flow-J/subprocessors/0"));
    }

    @Test
    public void dynamicFlowRefProcessorPathSameSubflowFromDifferentFlow() throws Exception {
        MuleEvent eventJ1 = FlowRefTestCase.getTestEvent((Object)"0");
        eventJ1.setFlowVariable("letter", (Object)"J");
        ((Flow)this.getFlowConstruct("flow2")).process(eventJ1);
        MuleEvent eventJ2 = FlowRefTestCase.getTestEvent((Object)"0");
        eventJ2.setFlowVariable("letter", (Object)"J");
        ((Flow)this.getFlowConstruct("flow3")).process(eventJ2);
        Assert.assertThat((Object)ProcessorPathAssertingProcessor.traversedProcessorPaths.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat(ProcessorPathAssertingProcessor.traversedProcessorPaths.get(0), (Matcher)Matchers.is((Object)"/flow2/processors/0/sub-flow-J/subprocessors/0"));
        Assert.assertThat(ProcessorPathAssertingProcessor.traversedProcessorPaths.get(1), (Matcher)Matchers.is((Object)"/flow3/processors/0/sub-flow-J/subprocessors/0"));
        Assert.assertThat(ProcessorPathAssertingProcessor.traversedProcessorPaths.get(2), (Matcher)Matchers.is((Object)"/flow3/processors/1/sub-flow-J/subprocessors/0"));
    }

    @Test
    public void dynamicFlowRefWithChoice() throws Exception {
        MuleEvent eventC = FlowRefTestCase.getTestEvent((Object)"0");
        eventC.setFlowVariable("letter", (Object)"C");
        Assert.assertEquals((Object)"0A", (Object)((Flow)this.getFlowConstruct("flow2")).process(eventC).getMessageAsString());
    }

    @Test
    public void dynamicFlowRefWithScatterGather() throws Exception {
        MuleEvent eventSG = FlowRefTestCase.getTestEvent((Object)"0");
        eventSG.setFlowVariable("letter", (Object)"SG");
        List payload = (List)((Flow)this.getFlowConstruct("flow2")).process(eventSG).getMessage().getPayload();
        Assert.assertEquals((Object)"0A", payload.get(0));
        Assert.assertEquals((Object)"0B", payload.get(1));
    }

    @Test(expected=MessagingException.class)
    public void flowRefNotFound() throws Exception {
        MuleEvent eventC = FlowRefTestCase.getTestEvent((Object)"0");
        eventC.setFlowVariable("letter", (Object)"Z");
        Assert.assertEquals((Object)"0C", (Object)((Flow)this.getFlowConstruct("flow2")).process(eventC).getMessageAsString());
    }

    @Ignore(value="MULE-10879: Non-blocking inheritance in flow refs causes SerialWorkManager to execute NB work")
    @Test
    public void nonBlockingFlowRef() throws Exception {
        Response response = Request.Post((String)String.format("http://localhost:%s/%s", this.port.getNumber(), "nonBlockingFlowRefBasic")).connectTimeout(5000).bodyString("Test Message", ContentType.TEXT_PLAIN).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.is((Object)"Test Message"));
        SensingNullRequestResponseMessageProcessor flow1RequestResponseProcessor = (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(FLOW1_SENSING_PROCESSOR_NAME);
        SensingNullRequestResponseMessageProcessor flow2RequestResponseProcessor = (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(FLOW2_SENSING_PROCESSOR_NAME);
        Assert.assertThat((Object)flow1RequestResponseProcessor.requestThread, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)flow1RequestResponseProcessor.responseThread)));
        Assert.assertThat((Object)flow2RequestResponseProcessor.requestThread, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)flow2RequestResponseProcessor.responseThread)));
    }

    @Test
    public void nonBlockingFlowRefToQueuedAsyncFlow() throws Exception {
        Response response = Request.Post((String)String.format("http://localhost:%s/%s", this.port.getNumber(), "nonBlockingFlowRefToQueuedAsyncFlow")).connectTimeout(5000).bodyString("Test Message", ContentType.TEXT_PLAIN).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)500));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.containsString((String)"Unable to process a synchronous or non-blocking event asynchronously"));
    }

    @Test
    public void nonBlockingFlowRefToAsyncFlow() throws Exception {
        Response response = Request.Post((String)String.format("http://localhost:%s/%s", this.port.getNumber(), "nonBlockingFlowRefToAsyncFlow")).connectTimeout(5000).bodyString("Test Message", ContentType.TEXT_PLAIN).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)500));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.containsString((String)"Unable to process a synchronous or non-blocking event asynchronously"));
    }

    @Test
    public void nonBlockingFlowRefToSyncFlow() throws Exception {
        Response response = Request.Post((String)String.format("http://localhost:%s/%s", this.port.getNumber(), "nonBlockingFlowRefToSyncFlow")).connectTimeout(5000).bodyString("Test Message", ContentType.TEXT_PLAIN).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.is((Object)"Test Message"));
        SensingNullRequestResponseMessageProcessor flow1RequestResponseProcessor = (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(TO_SYNC_FLOW1_SENSING_PROCESSOR_NAME);
        SensingNullRequestResponseMessageProcessor flow2RequestResponseProcessor = (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(TO_SYNC_FLOW2_SENSING_PROCESSOR_NAME);
        Assert.assertThat((Object)flow1RequestResponseProcessor.requestThread, (Matcher)CoreMatchers.equalTo((Object)flow1RequestResponseProcessor.responseThread));
        Assert.assertThat((Object)flow2RequestResponseProcessor.requestThread, (Matcher)CoreMatchers.equalTo((Object)flow2RequestResponseProcessor.responseThread));
    }

    @Test
    public void nonBlockingFlowRefErrorHandling() throws Exception {
        Response response = Request.Post((String)String.format("http://localhost:%s/%s", this.port.getNumber(), "nonBlockingFlowRefErrorHandling")).connectTimeout(5000).bodyString("Test Message", ContentType.TEXT_PLAIN).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.is((Object)ERROR_MESSAGE));
    }

    @Test
    public void pathsOnMultipleNestedSubFlows() throws Exception {
        List<String> level1 = Arrays.asList("subA", "subB");
        List<String> level2 = Arrays.asList("subX", "subY");
        List<String> level3 = Arrays.asList("subO", "subP");
        String mainFlowName = "mainFlowForDynamicSubflowTesting";
        String pathTemplate = "/mainFlowForDynamicSubflowTesting/processors/0/%s/subprocessors/0/%s/subprocessors/0/%s/subprocessors/0";
        this.assertSubFlowCombinations(Arrays.asList(level1, level2, level3), mainFlowName, pathTemplate);
    }

    @Test
    public void pathsOnMultipleNestedSubFlowsWithMixedMessageProcessors() throws Exception {
        List<String> level1 = Arrays.asList("subA", "subB");
        List<String> level2 = Arrays.asList("middleSubX", "middleSubY");
        List<String> level3 = Arrays.asList("middleSubO", "middleSubP");
        String mainFlowName = "mainFlowForDynamicSubflowTesting";
        String pathTemplate = "/mainFlowForDynamicSubflowTesting/processors/0/%s/subprocessors/0/%s/subprocessors/2/%s/subprocessors/2";
        this.assertSubFlowCombinations(Arrays.asList(level1, level2, level3), mainFlowName, pathTemplate);
    }

    private void assertSubFlowCombinations(List<List<String>> levels, String mainFlowName, String pathTemplate) throws Exception {
        Flow mainFlow = (Flow)this.getFlowConstruct(mainFlowName);
        List<List<String>> combinations = this.getPathCombinations(levels);
        for (List<String> subFlowCombination : combinations) {
            MuleEvent event = FlowRefTestCase.getTestEvent((Object)"0");
            event.setFlowVariable("subflows", subFlowCombination);
            String expectedPath = String.format(pathTemplate, subFlowCombination.toArray());
            mainFlow.process(event);
            Assert.assertThat(ProcessorPathAssertingProcessor.traversedProcessorPaths.get(0), (Matcher)Matchers.is((Object)expectedPath));
            ProcessorPathAssertingProcessor.traversedProcessorPaths.clear();
        }
    }

    private List<List<String>> getPathCombinations(List<List<String>> levels) {
        LinkedList<List<String>> combinations = new LinkedList<List<String>>();
        this.populatePathCombinations(levels, combinations, new LinkedList<String>(), 0);
        return combinations;
    }

    private void populatePathCombinations(List<List<String>> levels, List<List<String>> combinations, List<String> previousLevels, int currentLevelIndex) {
        if (currentLevelIndex == levels.size()) {
            combinations.add(previousLevels);
            return;
        }
        for (String levelRelativePath : levels.get(currentLevelIndex)) {
            LinkedList<String> tmpCombination = new LinkedList<String>(previousLevels);
            tmpCombination.add(levelRelativePath);
            this.populatePathCombinations(levels, combinations, tmpCombination, currentLevelIndex + 1);
        }
    }

    public static class ProcessorPathAssertingProcessor
    implements MessageProcessor {
        private static List<String> traversedProcessorPaths = new ArrayList<String>();

        public MuleEvent process(MuleEvent event) throws MuleException {
            traversedProcessorPaths.add(((Flow)muleContext.getRegistry().lookupFlowConstruct(event.getFlowConstruct().getName())).getProcessorPath((MessageProcessor)this));
            return event;
        }
    }
}

