/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.construct;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.integration.tck.WeatherForecaster;

public class WSProxyTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");
    private MuleClient muleClient;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/construct/ws-proxy-config.xml"}});
    }

    public WSProxyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = muleContext.getClient();
    }

    @Test
    public void testDynamicWsdl() throws Exception {
        this.testWsdlAndWebServiceRequests(0);
    }

    @Test
    public void testFileContentsWsdl() throws Exception {
        this.testWsdlAndWebServiceRequests(1);
    }

    @Test
    public void testStaticUriWsdl() throws Exception {
        this.testWsdlAndWebServiceRequests(2);
    }

    @Test
    public void testGlobalEndpoints() throws Exception {
        this.testWsdlAndWebServiceRequests(3);
    }

    @Test
    public void testTransformers() throws Exception {
        this.testWsdlAndWebServiceRequests(4);
    }

    @Test
    public void testExceptionStrategy() throws Exception {
        this.testWsdlAndWebServiceRequests(5);
    }

    @Test
    public void testInheritance() throws Exception {
        this.testWsdlAndWebServiceRequests(6);
    }

    @Test
    public void testEndpointChildren() throws Exception {
        this.testWsdlAndWebServiceRequests(7);
    }

    @Test
    public void testInheritanceAndEndpointChildren() throws Exception {
        this.testWsdlAndWebServiceRequests(8);
    }

    @Test
    public void testExpressionEndpoint() throws Exception {
        this.testWsdlAndWebServiceRequests(9);
    }

    @Test
    public void testResponsePropertiesPropagation() throws Exception {
        MuleMessage reply = this.performWebServiceRequest(10);
        Assert.assertNotNull((Object)reply.getInboundProperty("Content-Encoding"));
        Assert.assertEquals((Object)reply.getInboundProperty("Content-Encoding"), (Object)"gzip");
    }

    private void testWsdlAndWebServiceRequests(int proxyId) throws Exception {
        this.testWsdlRequest(proxyId);
        this.testWebServiceRequest(proxyId);
    }

    private void testWsdlRequest(int proxyId) throws Exception {
        String wsdl = this.muleClient.request("http://localhost:" + this.port1.getNumber() + "/weather-forecast/" + proxyId + "?wsdl", (long)this.getTestTimeoutSecs() * 1000L).getPayloadAsString();
        Assert.assertTrue((boolean)wsdl.contains("GetWeatherByZipCode"));
    }

    private void testWebServiceRequest(int proxyId) throws Exception {
        String weatherForecast = this.performWebServiceRequest(proxyId).getPayloadAsString();
        Assert.assertEquals((Object)new WeatherForecaster().getByZipCode("95050"), (Object)weatherForecast);
    }

    private MuleMessage performWebServiceRequest(int proxyId) throws MuleException {
        return this.muleClient.send("wsdl-cxf:http://localhost:" + this.port1.getNumber() + "/weather-forecast/" + proxyId + "?wsdl&method=GetWeatherByZipCode", (Object)"95050", null, (long)(this.getTestTimeoutSecs() * 1000));
    }
}

