/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.DomainFunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@RunWith(value=Parameterized.class)
public class JmsSharedConnectorTestCase
extends DomainFunctionalTestCase {
    public static final String CLIENT_APP = "client";
    public static final String SERVER_APP = "server";
    public static final String CONNECTOR_PARAMETER = "connector=sharedJmsConnector";
    @Rule
    public SystemProperty transportScheme = new SystemProperty("scheme", this.getTransportScheme());
    @Rule
    public SystemProperty connectorParameter = new SystemProperty("connectorParameter", "connector=sharedJmsConnector");
    private final String domainConfig;

    public JmsSharedConnectorTestCase(String domainConfig) {
        this.domainConfig = domainConfig;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"domain/jms/jms-activemq-embedded-shared-connector.xml"}, {"domain/jms/jms-custom-shared-connector.xml"}, {"domain/jms/jms-shared-connnector.xml"}, {"domain/jms/jms-caching-connection-factory-shared-connnector.xml"});
    }

    protected String getDomainConfig() {
        return this.domainConfig;
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, CLIENT_APP, new String[]{"domain/jms/jms-client-app.xml"}), new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, SERVER_APP, new String[]{"domain/jms/jms-server-app.xml"})};
    }

    @Test
    public void clientCallServerUsingRequestResponse() throws Exception {
        this.executeScenario("in", "out2");
    }

    @Test
    public void clientCallServerUsingRequestReply() throws Exception {
        this.executeScenario("in2", "out5");
    }

    private void executeScenario(String inQueue, final String outQueue) throws Exception {
        this.getMuleContextForApp(CLIENT_APP).getClient().dispatch(this.queueAddress(inQueue), (Object)"test", null);
        final AtomicReference response = new AtomicReference();
        new PollingProber(10000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                MuleMessage responseMessage;
                try {
                    responseMessage = JmsSharedConnectorTestCase.this.getMuleContextForApp(JmsSharedConnectorTestCase.CLIENT_APP).getClient().request(JmsSharedConnectorTestCase.this.queueAddress(outQueue), 10L);
                }
                catch (MuleException e) {
                    throw new RuntimeException(e);
                }
                if (responseMessage != null) {
                    response.set(responseMessage);
                    return true;
                }
                return false;
            }

            public String describeFailure() {
                return "response message never arrived";
            }
        });
        Assert.assertThat((Object)((MuleMessage)response.get()).getPayloadAsString(), (Matcher)Is.is((Object)"works"));
    }

    private String queueAddress(String inQueue) {
        return String.format("%s://%s?%s", this.getTransportScheme(), inQueue, CONNECTOR_PARAMETER);
    }

    protected String getTransportScheme() {
        return "jms";
    }
}

