/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.properties;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.DomainContextBuilder;

public class DomainPropertiesPlaceHolderPropagationTestCase
extends AbstractMuleTestCase {
    private MuleContext domainContext;
    private MuleContext applicationContext;

    @Test
    public void propertiesPropagatesToAppUsingContext() throws Exception {
        this.configureContexts("domain/properties/shared-context-properties.xml", "domain/properties/app-with-no-properties.xml");
        this.propertiesPropagatesScenario();
    }

    @Test
    public void appPropertiesPrecedeDomainPropertiesUsingContext() throws Exception {
        this.configureContexts("domain/properties/shared-context-properties.xml", "domain/properties/app-with-context-properties.xml");
        this.appPropertiesPrecedeDomainPropertiesScenario();
    }

    @Test
    public void propertiesPropagatesToAppUsingBeans() throws Exception {
        this.configureContexts("domain/properties/shared-beans-properties.xml", "domain/properties/app-with-no-properties.xml");
        this.propertiesPropagatesScenario();
    }

    @Test
    public void appPropertiesPrecedeDomainPropertiesUsingBeans() throws Exception {
        this.configureContexts("domain/properties/shared-beans-properties.xml", "domain/properties/app-with-beans-properties.xml");
        this.appPropertiesPrecedeDomainPropertiesScenario();
    }

    @Test
    public void propertiesPropagatesToAppUsingContextAndBeans() throws Exception {
        this.configureContexts("domain/properties/shared-context-properties.xml", "domain/properties/app-with-no-properties.xml");
        this.propertiesPropagatesScenario();
    }

    @Test
    public void appPropertiesPrecedeDomainPropertiesUsingContextAndBeans() throws Exception {
        this.configureContexts("domain/properties/shared-beans-properties.xml", "domain/properties/app-with-context-properties.xml");
        this.appPropertiesPrecedeDomainPropertiesScenario();
    }

    private void appPropertiesPrecedeDomainPropertiesScenario() {
        String domainPropertyObject = (String)this.domainContext.getRegistry().lookupObject("domainPropertyObject");
        Assert.assertThat((Object)domainPropertyObject, (Matcher)Is.is((Object)"9999"));
        String appPropertyObject = (String)this.applicationContext.getRegistry().lookupObject("appPropertyObject");
        Assert.assertThat((Object)appPropertyObject, (Matcher)Is.is((Object)"10000"));
        String app2PropertyObject = (String)this.applicationContext.getRegistry().lookupObject("app2PropertyObject");
        Assert.assertThat((Object)app2PropertyObject, (Matcher)Is.is((Object)"service"));
    }

    private void propertiesPropagatesScenario() {
        String domainPropertyObject = (String)this.domainContext.getRegistry().lookupObject("domainPropertyObject");
        Assert.assertThat((Object)domainPropertyObject, (Matcher)Is.is((Object)"9999"));
        String appPropertyObject = (String)this.applicationContext.getRegistry().lookupObject("appPropertyObject");
        Assert.assertThat((Object)appPropertyObject, (Matcher)Is.is((Object)"9999"));
    }

    private void configureContexts(String domainConfig, String appConfig) throws Exception {
        this.domainContext = new DomainContextBuilder().setDomainConfig(domainConfig).build();
        this.applicationContext = new ApplicationContextBuilder().setApplicationResources(new String[]{appConfig}).setDomainContext(this.domainContext).build();
    }

    @After
    public void after() {
        if (this.applicationContext != null) {
            this.applicationContext.dispose();
        }
        if (this.domainContext != null) {
            this.domainContext.dispose();
        }
    }
}

