/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactory;

public class CatchExceptionStrategyTestCase
extends AbstractServiceAndFlowTestCase {
    public static final int TIMEOUT = 5000;
    public static final String ERROR_PROCESSING_NEWS = "error processing news";
    public static final String JSON_RESPONSE = "{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}";
    public static final String JSON_REQUEST = "{\"userId\":\"15\"}";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");
    private DefaultTlsContextFactory tlsContextFactory;
    public static final String MESSAGE = "some message";
    public static final String MESSAGE_EXPECTED = "some message consumed successfully";

    public CatchExceptionStrategyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/catch-exception-strategy-use-case-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/catch-exception-strategy-use-case-flow.xml"});
    }

    @Before
    public void setup() throws IOException {
        this.tlsContextFactory = new DefaultTlsContextFactory();
        this.tlsContextFactory.setTrustStorePath("ssltest-cacerts.jks");
        this.tlsContextFactory.setTrustStorePassword("changeit");
    }

    @Test
    public void testHttpJsonErrorResponse() throws Exception {
        this.testJsonErrorResponse(String.format("http://localhost:%s/service", this.dynamicPort1.getNumber()));
    }

    @Test
    public void testHttpsJsonErrorResponse() throws Exception {
        this.testJsonErrorResponse(String.format("https://localhost:%s/httpsservice", this.dynamicPort3.getNumber()));
    }

    @Test
    public void testVmJsonErrorResponse() throws Exception {
        this.testJsonErrorResponse("vm://in");
    }

    @Test
    public void testJmsJsonErrorResponse() throws Exception {
        this.testJsonErrorResponse("jms://in");
    }

    @Test
    public void testTcpJsonErrorResponse() throws Exception {
        this.testJsonErrorResponse(String.format("tcp://localhost:%s", this.dynamicPort2.getNumber()));
    }

    private void testJsonErrorResponse(String endpointUri) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HttpRequestOptions httpRequestOptions = ((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).tlsContextFactory((TlsContextFactory)this.tlsContextFactory).responseTimeout(5000L)).build();
        MuleMessage response = client.send(endpointUri, CatchExceptionStrategyTestCase.getTestMuleMessage((Object)JSON_REQUEST), (OperationOptions)httpRequestOptions);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(response.getPayloadAsString());
        JsonNode expectedJsonNode = mapper.readTree(JSON_RESPONSE);
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    @Test
    public void testCatchWithComponent() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in2", (Object)MESSAGE, null);
        MuleMessage result = client.send("vm://in2", (Object)MESSAGE, null, 5000L);
        Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Is.is((Object)"some message Caught"));
    }

    @Test
    public void testFullyDefinedCatchExceptionStrategyWithComponent() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = null;
        result = client.send("vm://in3", (Object)MESSAGE, null, 5000L);
        Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Is.is((Object)"some message apt1 apt2 groovified"));
    }

    @WebService
    public static class Echo {
        @WebResult(name="text")
        public String echo(@WebParam(name="text") String string) {
            throw new RuntimeException();
        }
    }

    public static class NewsResponse {
        private int userId;
        private String title;
        private String errorMessage;

        public int getUserId() {
            return this.userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class NewsRequest {
        private int userId;

        public int getUserId() {
            return this.userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }
    }

    public static class NewsErrorProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            ((NewsResponse)event.getMessage().getPayload()).setErrorMessage(CatchExceptionStrategyTestCase.ERROR_PROCESSING_NEWS);
            return event;
        }
    }

    public static class LoadNewsProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            NewsRequest newsRequest = (NewsRequest)event.getMessage().getPayload();
            NewsResponse newsResponse = new NewsResponse();
            newsResponse.setUserId(newsRequest.getUserId());
            newsResponse.setTitle("News title");
            event.getMessage().setPayload((Object)newsResponse);
            return event;
        }
    }
}

