/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.sql.SQLDataException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.registry.ResolverException;
import org.mule.config.i18n.CoreMessages;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;

public class ChoiceExceptionStrategyTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/choice-exception-strategy.xml";
    }

    @Test
    public void testMatchesCorrectExceptionStrategy() throws Exception {
        this.callVmAndThrowException(new IllegalStateException(), "0 catch-2");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingWrapper() throws Exception {
        this.callVmAndThrowException((Exception)new ResolverException(CoreMessages.createStaticMessage((String)""), (Throwable)new IllegalStateException()), "0 catch-2");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingWrapperAndCause() throws Exception {
        this.callVmAndThrowException((Exception)new ResolverException(CoreMessages.createStaticMessage((String)""), (Throwable)new RuntimeException(new IllegalStateException())), "0 catch-2");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingBaseClass() throws Exception {
        this.callVmAndThrowException(new BaseException(), "0 catch-3");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingSubtypeClass() throws Exception {
        this.callVmAndThrowException((Exception)new ResolverException(CoreMessages.createStaticMessage((String)""), (Throwable)new SubtypeException()), "0 catch-4");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingSubtypeSubtypeClass() throws Exception {
        this.callVmAndThrowException(new SubtypeSubtypeException(), "0 catch-4");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingRegex() throws Exception {
        this.callVmAndThrowException(new AnotherTypeMyException(), "0 catch-5");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingGroovyExpressionEvaluator() throws Exception {
        this.callVmAndThrowException("groovy", new SQLDataException(), "groovy catch-6");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingStartsWithWildcard() throws Exception {
        this.callVmAndThrowException(new StartsWithException(), "0 catch-7");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingFinishesWithWildcard() throws Exception {
        this.callVmAndThrowException(new ThisExceptionFinishesWithException(), "0 catch-8");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingMatchesAll() throws Exception {
        this.callVmAndThrowException(new AnotherTotallyDifferentKindOfException(), "0 catch-9");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingFinishesWithSomethingElse() throws Exception {
        this.callVmAndThrowException(new ThisExceptionFinishesWithSomethingElse(), "0 groovified");
    }

    @Test
    public void testMatchesCorrectExceptionUsingNoCause() throws Exception {
        this.callVmAndThrowException((Exception)new ResolverException(CoreMessages.createStaticMessage((String)"")), "{NullPayload}");
    }

    @Test
    public void testNoMatchThenCallDefaultExceptionStrategy() throws Exception {
        this.callVmAndThrowException(new ArithmeticException(), "0 global catch es");
    }

    private void callVmAndThrowException(Exception exceptionToThrow, String expectedMessage) throws Exception {
        this.callVmAndThrowException("0", exceptionToThrow, expectedMessage);
    }

    private void callVmAndThrowException(Object payload, final Exception exceptionToThrow, String expectedMessage) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("matchesCorrectExceptionStrategyUsingExceptionType");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                throw exceptionToThrow;
            }
        });
        MuleMessage response = client.send("vm://in", payload, null);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)expectedMessage));
    }

    public static class AnotherTotallyDifferentKindOfException
    extends Exception {
    }

    public static class ThisExceptionFinishesWithSomethingElse
    extends Exception {
    }

    public static class ThisExceptionFinishesWithException
    extends Exception {
    }

    public static class StartsWithException
    extends Exception {
    }

    public static class AnotherTypeMyException
    extends Exception {
    }

    public static class SubtypeSubtypeException
    extends SubtypeException {
    }

    public static class SubtypeException
    extends BaseException {
    }

    public static class BaseException
    extends Exception {
    }
}

