/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.message.ExceptionMessage;
import org.mule.routing.outbound.MulticastingRouter;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class DefaultServiceExceptionStrategyTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/default-service-exception-strategy-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/default-service-exception-strategy-config-flow.xml"});
    }

    public DefaultServiceExceptionStrategyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testDefaultExceptionStrategySingleEndpoint() throws MuleException {
        Object service = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? muleContext.getRegistry().lookupFlowConstruct("testService1") : muleContext.getRegistry().lookupService("testService1");
        Assert.assertNotNull((Object)service);
        Assert.assertNotNull((Object)service.getExceptionListener());
        Assert.assertTrue((boolean)(service.getExceptionListener() instanceof DefaultMessagingExceptionStrategy));
        Assert.assertEquals((long)1L, (long)((DefaultMessagingExceptionStrategy)service.getExceptionListener()).getMessageProcessors().size());
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in1", (Object)"test", null);
        this.assertExceptionMessage(client.request("vm://out1", 5000L));
        Assert.assertNull((Object)client.request("vm://out1", 5000L));
    }

    @Test
    public void testDefaultExceptionStrategyMultipleEndpoints() throws MuleException {
        Object service = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? muleContext.getRegistry().lookupFlowConstruct("testService2") : muleContext.getRegistry().lookupService("testService2");
        Assert.assertNotNull((Object)service);
        Assert.assertNotNull((Object)service.getExceptionListener());
        Assert.assertTrue((boolean)(service.getExceptionListener() instanceof DefaultMessagingExceptionStrategy));
        DefaultMessagingExceptionStrategy exceptionListener = (DefaultMessagingExceptionStrategy)service.getExceptionListener();
        MessageProcessor mp = (MessageProcessor)exceptionListener.getMessageProcessors().iterator().next();
        Assert.assertTrue((String)mp.getClass().getName(), (boolean)(mp instanceof MulticastingRouter));
        Assert.assertEquals((long)2L, (long)((MulticastingRouter)mp).getRoutes().size());
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in2", (Object)"test", null);
        MuleMessage out2 = client.request("vm://out2", 5000L);
        MuleMessage out3 = client.request("vm://out3", 5000L);
        this.assertExceptionMessage(out2);
        this.assertExceptionMessage(out3);
        Assert.assertNotSame((Object)out2, (Object)out3);
        Assert.assertEquals((Object)out2.getPayload(), (Object)out3.getPayload());
    }

    @Test
    public void testDefaultExceptionStrategyNonEndpoint() throws Exception {
        LocalMuleClient mc = muleContext.getClient();
        mc.dispatch("vm://in3", (Object)"test", null);
        MuleMessage out4 = mc.request("vm://out4", 5000L);
        Assert.assertEquals((Object)"ERROR!", (Object)out4.getPayloadAsString());
    }

    @Test
    public void testSerializablePayload() throws MuleException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key1", "value1");
        map.put("key2", "value2");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in1", map, null);
        MuleMessage message = client.request("vm://out1", 5000L);
        Assert.assertTrue((boolean)(message.getPayload() instanceof ExceptionMessage));
        Object payload = ((ExceptionMessage)message.getPayload()).getPayload();
        Assert.assertTrue((String)("payload shoud be a Map, but is " + payload.getClass().getName()), (boolean)(payload instanceof Map));
        Map payloadMap = (Map)payload;
        Assert.assertEquals((Object)"value1", payloadMap.get("key1"));
        Assert.assertEquals((Object)"value2", payloadMap.get("key2"));
    }

    @Test
    public void testStopsServiceOnException() throws MuleException, InterruptedException {
        Object service = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? muleContext.getRegistry().lookupFlowConstruct("testService5") : muleContext.getRegistry().lookupService("testService5");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in5", (Object)"test", null);
        this.assertExceptionMessage(client.request("vm://out5", 5000L));
        PollingProber prober = new PollingProber(5000L, 100L);
        prober.check(new Probe((FlowConstruct)service){
            final /* synthetic */ FlowConstruct val$service;
            {
                this.val$service = flowConstruct;
            }

            public boolean isSatisfied() {
                return !this.val$service.getLifecycleState().isStarted();
            }

            public String describeFailure() {
                return "Service was not stopped after processing the exception";
            }
        });
    }

    private void assertExceptionMessage(MuleMessage out) {
        Assert.assertTrue((boolean)(out.getPayload() instanceof ExceptionMessage));
        ExceptionMessage exceptionMessage = (ExceptionMessage)out.getPayload();
        Assert.assertEquals(FunctionalTestException.class, exceptionMessage.getException().getCause().getClass());
        Assert.assertEquals((Object)"test", (Object)exceptionMessage.getPayload());
    }
}

