/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.exception.CatchMessagingExceptionStrategy;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.exception.MessagingExceptionHandlerToSystemAdapter;
import org.mule.exception.RollbackMessagingExceptionStrategy;
import org.mule.tck.junit4.FunctionalTestCase;

public class ExceptionHandlingTestCase
extends FunctionalTestCase {
    public static final String MESSAGE = "some message";
    private static MessagingExceptionHandler injectedMessagingExceptionHandler;
    private static CountDownLatch latch;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-handling-test.xml";
    }

    protected void doSetUp() throws Exception {
        injectedMessagingExceptionHandler = null;
    }

    @Test
    public void testCustomProcessorInFlow() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://inFlow1", (Object)MESSAGE, null);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)((Boolean)response.getProperty("expectedHandler", PropertyScope.SESSION)));
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof DefaultMessagingExceptionStrategy));
    }

    @Test
    public void testOutboundEndpointInFlow() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inFlow2", (Object)MESSAGE, null);
        MuleMessage response = client.request("vm://outFlow2", 3000L);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testOutboundDynamicEndpointInFlow() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inFlow3", (Object)MESSAGE, this.getMessageProperties());
        MuleMessage response = client.request("vm://outFlow3", 3000L);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testAsyncInFlow() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inFlow4", (Object)MESSAGE, null);
        MuleMessage response = client.request("vm://outFlow4", 3000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof CatchMessagingExceptionStrategy));
    }

    @Test
    public void testUntilSuccessfulInFlow() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inFlow5", (Object)MESSAGE, null);
        MuleMessage response = client.request("vm://outFlow5", 3000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof CatchMessagingExceptionStrategy));
    }

    @Test
    public void testCustomProcessorInScope() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        LinkedList<String> list = new LinkedList<String>();
        list.add(MESSAGE);
        MuleMessage response = client.send("vm://inScope1", list, null);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)((Boolean)response.getProperty("expectedHandler", PropertyScope.SESSION)));
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof RollbackMessagingExceptionStrategy));
    }

    @Test
    public void testOutboundEndpointInScope() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        LinkedList<String> list = new LinkedList<String>();
        list.add(MESSAGE);
        client.send("vm://inScope2", list, null);
        MuleMessage response = client.request("vm://outScope2", 3000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)((Boolean)response.getProperty("expectedHandler", PropertyScope.SESSION)));
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof RollbackMessagingExceptionStrategy));
    }

    @Test
    public void testOutboundDynamicEndpointInScope() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        LinkedList<String> list = new LinkedList<String>();
        list.add(MESSAGE);
        client.send("vm://inScope3", list, this.getMessageProperties());
        MuleMessage response = client.request("vm://outScope3", 3000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)((Boolean)response.getProperty("expectedHandler", PropertyScope.SESSION)));
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof RollbackMessagingExceptionStrategy));
    }

    @Test
    public void testCustomProcessorInTransactionalScope() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inTransactional1", (Object)MESSAGE, null);
        MuleMessage response = client.request("vm://outTransactional1", 3000L);
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)((Boolean)response.getProperty("expectedHandler", PropertyScope.SESSION)));
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof CatchMessagingExceptionStrategy));
    }

    @Test
    public void testOutboundEndpointInTransactionalScope() throws Exception {
        this.testTransactionalScope("vm://inTransactional2", "vm://outTransactional2", null);
    }

    @Test
    public void testOutboundDynamicEndpointInTransactionalScope() throws Exception {
        this.testTransactionalScope("vm://inTransactional3", "vm://outTransactional3", this.getMessageProperties());
    }

    @Test
    public void testAsyncInTransactionalScope() throws Exception {
        this.testTransactionalScope("vm://inTransactional4", "vm://outTransactional4", null);
    }

    @Test
    public void testUntilSuccessfulInTransactionalScope() throws Exception {
        this.testTransactionalScope("vm://inTransactional5", "vm://outTransactional5", null);
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof CatchMessagingExceptionStrategy));
    }

    @Test
    public void testCustomProcessorInExceptionStrategy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inStrategy1", (Object)MESSAGE, null);
        MuleMessage response = client.request("vm://outStrategy1", 3000L);
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)((Boolean)response.getProperty("expectedHandler", PropertyScope.SESSION)));
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof MessagingExceptionHandlerToSystemAdapter));
    }

    @Test
    public void testOutboundEndpointInExceptionStrategy() throws Exception {
        this.testExceptionStrategy("vm://inStrategy2", null);
    }

    @Test
    public void testOutboundDynamicEndpointInExceptionStrategy() throws Exception {
        this.testExceptionStrategy("vm://inStrategy3", this.getMessageProperties());
    }

    @Test
    public void testAsyncInExceptionStrategy() throws Exception {
        this.testExceptionStrategy("vm://inStrategy4", null);
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof MessagingExceptionHandlerToSystemAdapter));
    }

    @Test
    public void testUntilSuccessfulInExceptionStrategy() throws Exception {
        this.testExceptionStrategy("vm://inStrategy5", null);
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof MessagingExceptionHandlerToSystemAdapter));
    }

    @Test
    public void testUntilSuccessfulInExceptionStrategyRollback() throws Exception {
        this.testExceptionStrategy("vm://inStrategy6", null);
        Assert.assertTrue((boolean)(injectedMessagingExceptionHandler instanceof MessagingExceptionHandlerToSystemAdapter));
    }

    private Map<String, Object> getMessageProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("host", "localhost");
        return props;
    }

    private void testTransactionalScope(String destination, String expected, Map<String, Object> messageProperties) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send(destination, (Object)MESSAGE, messageProperties);
        MuleMessage response = client.request(expected, 3000L);
        Assert.assertNotNull((Object)response);
    }

    private void testExceptionStrategy(String destination, Map<String, Object> messageProperties) throws MuleException, InterruptedException {
        latch = (CountDownLatch)Mockito.spy((Object)new CountDownLatch(2));
        LocalMuleClient client = muleContext.getClient();
        client.dispatch(destination, (Object)MESSAGE, messageProperties);
        Assert.assertFalse((boolean)latch.await(3L, TimeUnit.SECONDS));
        ((CountDownLatch)Mockito.verify((Object)latch)).countDown();
    }

    public static class ExceptionHandlerVerifierProcessor
    implements MessageProcessor,
    MessagingExceptionHandlerAware {
        private MessagingExceptionHandler messagingExceptionHandler;

        public synchronized MuleEvent process(MuleEvent event) throws MuleException {
            Boolean expectedHandler = this.messagingExceptionHandler != null;
            if (expectedHandler.booleanValue()) {
                expectedHandler = this.messagingExceptionHandler.equals(event.getFlowConstruct().getExceptionListener());
            }
            event.getMessage().setProperty("expectedHandler", (Object)expectedHandler, PropertyScope.SESSION);
            injectedMessagingExceptionHandler = this.messagingExceptionHandler;
            return event;
        }

        public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
            if (this.messagingExceptionHandler == null) {
                this.messagingExceptionHandler = messagingExceptionHandler;
            }
        }
    }

    public static class ExecutionCountProcessor
    implements MessageProcessor {
        public synchronized MuleEvent process(MuleEvent event) throws MuleException {
            latch.countDown();
            return event;
        }
    }
}

