/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.tck.junit4.FunctionalTestCase;

public class ExceptionPropagationMule5737TestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-propagation-mule-5737-config.xml";
    }

    @Test
    public void testVMRequestResponseEndpointExceptionPropagation() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://flow-in", (Object)"", null);
    }

    @Test
    public void testFlowWithChildFlowExceptionPropagation() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        FlowConstruct flow = muleContext.getRegistry().lookupFlowConstruct("flowWithChildFlow");
        FlowConstruct childFlow = muleContext.getRegistry().lookupFlowConstruct("childFlow");
        SensingExceptionStrategy parentES = (SensingExceptionStrategy)flow.getExceptionListener();
        SensingExceptionStrategy childFlowES = (SensingExceptionStrategy)childFlow.getExceptionListener();
        client.send("vm://flowWithChildFlow-in", (Object)"", null);
        Assert.assertFalse((boolean)parentES.caught);
        Assert.assertTrue((boolean)childFlowES.caught);
    }

    @Test
    public void testFlowWithSubFlowExceptionPropagation() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        SensingExceptionStrategy parentES = (SensingExceptionStrategy)muleContext.getRegistry().lookupFlowConstruct("flowWithSubFlow").getExceptionListener();
        client.send("vm://flowWithSubFlow-in", (Object)"", null);
        Assert.assertTrue((boolean)parentES.caught);
    }

    @Test
    public void testFlowWithChildServiceExceptionPropagation() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        SensingExceptionStrategy parentES = (SensingExceptionStrategy)muleContext.getRegistry().lookupFlowConstruct("flowWithChildService").getExceptionListener();
        SensingExceptionStrategy childServiceES = (SensingExceptionStrategy)muleContext.getRegistry().lookupFlowConstruct("childService").getExceptionListener();
        client.send("vm://flowWithChildService-in", (Object)"", null);
        Assert.assertFalse((boolean)parentES.caught);
        Assert.assertTrue((boolean)childServiceES.caught);
    }

    public static class SensingExceptionStrategy
    extends AbstractMessagingExceptionStrategy {
        boolean caught;

        public SensingExceptionStrategy() {
            super(null);
        }

        public MuleEvent handleException(Exception e, MuleEvent event) {
            this.caught = true;
            MuleEvent resultEvent = super.handleException(e, event);
            resultEvent.getMessage().setExceptionPayload(null);
            ((MessagingException)((Object)e)).setHandled(true);
            return resultEvent;
        }
    }
}

