/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.tck.junit4.FunctionalTestCase;

public class RollbackExceptionStrategyRedeliveryCountTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        System.setProperty("MULE_FORCE_REDELIVERY", "true");
        return "org/mule/test/integration/exceptions/rollback-exception-strategy-redelivery-count.xml";
    }

    @After
    public void after() {
        System.setProperty("MULE_FORCE_REDELIVERY", "false");
    }

    @Test
    public void testRollbackExceptionStrategyNumberOfRetries() throws Exception {
        final CountDownLatch latch = new CountDownLatch(8);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                latch.countDown();
            }
        });
        client.dispatch("vm://in8", (Object)"test", null);
        client.dispatch("vm://in8", (Object)"test", null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 8 times");
        }
        MuleMessage response = client.request("vm://dlqCounter", 20000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        AtomicInteger counter = (AtomicInteger)muleContext.getRegistry().lookupObject("counter");
        Assert.assertThat((Object)counter.get(), (Matcher)Is.is((Object)8));
    }
}

