/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.filter;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.component.DefaultJavaComponent;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.routing.MessageFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class MessageFilterNotificationsTestCase
extends FunctionalTestCase {
    private List<MessageProcessorNotification> notifications = new ArrayList<MessageProcessorNotification>();

    @Before
    public void setUp() throws Exception {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        muleContext.registerListener((ServerNotificationListener)new MessageProcessorNotificationListener(){

            public void onNotification(ServerNotification notification) {
                MessageFilterNotificationsTestCase.this.notifications.add((MessageProcessorNotification)notification);
            }
        });
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/filter/message-filter-notification-config.xml";
    }

    @Test
    public void testNotificationSubFlow() throws Exception {
        this.runFlow("unacceptedCaseSubFlow");
        this.assertNotifications();
    }

    @Test
    public void testNotificationFlow() throws Exception {
        this.runFlow("unacceptedCaseFlow");
        this.assertNotifications();
    }

    private void assertNotifications() {
        Assert.assertThat(this.notifications, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.notifications.size(), (Matcher)CoreMatchers.is((Object)6));
        this.assertNotification(this.notifications.get(0), MessageFilter.class, 1601);
        this.assertNotification(this.notifications.get(1), MessageFilter.class, 1603);
        this.assertNotification(this.notifications.get(2), DefaultJavaComponent.class, 1601);
        this.assertNotification(this.notifications.get(3), DefaultJavaComponent.class, 1603);
        this.assertNotification(this.notifications.get(4), DefaultJavaComponent.class, 1602);
        this.assertNotification(this.notifications.get(5), MessageFilter.class, 1602);
    }

    private void assertNotification(MessageProcessorNotification notification, Class processorClass, int action) {
        Assert.assertThat((Object)notification.getProcessor(), (Matcher)CoreMatchers.instanceOf((Class)processorClass));
        Assert.assertThat((Object)notification.getAction(), (Matcher)CoreMatchers.is((Object)action));
    }
}

