/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.http;

import java.io.File;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.util.ClassUtils;

public abstract class AbstractServerTlsRestrictedProtocolsAndCiphersTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpsPort = new DynamicPort("port");
    private static final String SERVER_CIPHER_SUITE_ENABLED = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256";
    private static final String SERVER_CIPHER_SUITE_DISABLED = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    private static final String SERVER_PROTOCOL_ENABLED = "TLSv1.2";
    private static final String SERVER_PROTOCOL_DISABLED = "TLSv1";

    @BeforeClass
    public static void createTlsPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(AbstractServerTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile(), "UTF-8");
        writer.println("enabledCipherSuites=TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        writer.println("enabledProtocols=TLSv1.2");
        writer.close();
    }

    @AfterClass
    public static void removeTlsPropertiesFile() {
        AbstractServerTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile().delete();
    }

    private static File getTlsPropertiesFile() {
        String path = ClassUtils.getClassPathRoot(AbstractServerTlsRestrictedProtocolsAndCiphersTestCase.class).getPath();
        return new File(path, String.format("tls-%s.conf", "default"));
    }

    @Test
    public void handshakeSuccessWhenUsingEnabledCipherSpec() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        SSLSocket socket = this.createSocket(new String[]{SERVER_CIPHER_SUITE_ENABLED, SERVER_CIPHER_SUITE_DISABLED}, new String[]{SERVER_PROTOCOL_ENABLED, SERVER_PROTOCOL_DISABLED});
        socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                latch.countDown();
            }
        });
        socket.startHandshake();
        Assert.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)SERVER_CIPHER_SUITE_ENABLED, (Object)socket.getSession().getCipherSuite());
        Assert.assertEquals((Object)SERVER_PROTOCOL_ENABLED, (Object)socket.getSession().getProtocol());
        socket.close();
    }

    @Test(expected=SSLException.class)
    public void handshakeFailureWithDisabledCipherSuite() throws Exception {
        SSLSocket socket = this.createSocket(new String[]{SERVER_CIPHER_SUITE_DISABLED}, new String[]{SERVER_PROTOCOL_ENABLED});
        socket.startHandshake();
    }

    @Test(expected=SSLException.class)
    public void handshakeFailureWithDisabledProtocol() throws Exception {
        SSLSocket socket = this.createSocket(new String[]{SERVER_CIPHER_SUITE_ENABLED}, new String[]{SERVER_PROTOCOL_DISABLED});
        socket.startHandshake();
    }

    private SSLSocket createSocket(String[] cipherSuites, String[] enabledProtocols) throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
        tlsContextFactory.setTrustStorePath("trustStore");
        tlsContextFactory.setTrustStorePassword("mulepassword");
        tlsContextFactory.initialise();
        SSLContext sslContext = tlsContextFactory.createSslContext();
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)socketFactory.createSocket("localhost", this.httpsPort.getNumber());
        socket.setEnabledCipherSuites(cipherSuites);
        socket.setEnabledProtocols(enabledProtocols);
        return socket;
    }
}

