/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.messaging.meps;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.exceptions.FunctionalTestException;

public class SynchronousResponseExceptionTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/messaging/meps/synchronous-response-exception-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/messaging/meps/synchronous-response-exception-flow.xml"});
    }

    public SynchronousResponseExceptionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testComponentException() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://in1", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(FunctionalTestException.class, message.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testOutboundRoutingException() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://in2", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(NoReceiverForEndpointException.class, message.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testInboundTransformerException() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://in3", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(TransformerException.class, message.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testOutboundTransformerException() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://in4", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(TransformerException.class, message.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testResponseTransformerException() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://in5", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(TransformerException.class, message.getExceptionPayload().getRootException().getClass());
    }
}

