/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.RoutingNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.RoutingNotification;
import org.mule.tck.junit4.FunctionalTestCase;

public class AsyncReplyTimeoutTestCase
extends FunctionalTestCase {
    private CountDownLatch latch;

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/multi-async-repy-timeout.xml";
    }

    @Test
    public void testAggregatorTimeoutWithoutFailure() throws Exception {
        this.latch = new CountDownLatch(1);
        muleContext.registerListener((ServerNotificationListener)new RoutingNotificationListener<RoutingNotification>(){

            public void onNotification(RoutingNotification notification) {
                if (notification.getAction() == 1304) {
                    AsyncReplyTimeoutTestCase.this.latch.countDown();
                    Assert.assertEquals((Object)"test Received Late!", (Object)((MuleMessage)notification.getSource()).getPayload());
                }
            }
        });
        String message = "test";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://distributor.queue", (Object)message, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection mc = (MuleMessageCollection)result;
        Assert.assertEquals((long)2L, (long)mc.size());
        for (int i = 0; i < mc.getMessagesAsArray().length; ++i) {
            MuleMessage msg = mc.getMessagesAsArray()[i];
            Assert.assertEquals((Object)"test Received", (Object)msg.getPayload());
        }
        Assert.assertTrue((boolean)this.latch.await(3000L, TimeUnit.MILLISECONDS));
    }
}

