/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;

public class ExceptionBasedRouterTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/outbound/exception-based-router-service.xml"}});
    }

    public ExceptionBasedRouterTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testStaticEndpointsByName() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("vm://in1", (Object)"request", null);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"success", (Object)reply.getPayload());
    }

    @Test
    public void testStaticEndpointsByURI() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("vm://in2", (Object)"request", null);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"success", (Object)reply.getPayload());
    }

    @Test
    public void testDynamicEndpointsByName() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("recipients", "service1,service2,service3");
        MuleMessage reply = client.send("vm://in3", (Object)"request", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"success", (Object)reply.getPayload());
    }

    @Test
    public void testDynamicEndpointsByURI() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap props = new HashMap();
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("vm://service4?responseTransformers=validateResponse&exchangePattern=request-response");
        recipients.add("vm://service5?responseTransformers=validateResponse&exchangePattern=request-response");
        recipients.add("vm://service6?responseTransformers=validateResponse&exchangePattern=request-response");
        props.put("recipients", recipients);
        MuleMessage reply = client.send("vm://in3", (Object)"request", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"success", (Object)reply.getPayload());
    }

    @Test
    public void testIllegalEndpoint() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap props = new HashMap();
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("vm://service998?exchangePattern=request-response");
        recipients.add("vm://service5?exchangePattern=request-response");
        recipients.add("vm://service999");
        props.put("recipients", recipients);
        MuleMessage reply = client.send("vm://in3", (Object)"request", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"success", (Object)reply.getPayload());
    }

    @Test
    public void testTransactionIsNotRolledBack() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("jms://in", (Object)"some message", null, 5000L);
        Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)((NullPayload)result.getPayload()), (Matcher)Is.is((Object)NullPayload.getInstance()));
        Assert.assertThat((Object)result.getExceptionPayload(), (Matcher)IsNull.nullValue());
        MuleMessage outputMessage = client.request("jms://out", 5000L);
        Assert.assertThat((Object)outputMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)outputMessage.getPayloadAsString(), (Matcher)Is.is((Object)"some message"));
    }
}

