/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.replyto;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.concurrent.Latch;

public class ReplyToChainIntegration5TestCase
extends AbstractServiceAndFlowTestCase {
    public static final String TEST_PAYLOAD = "test payload";
    public static final String EXPECTED_PAYLOAD = "test payload modified";
    public static final int TIMEOUT = 5000;

    public ReplyToChainIntegration5TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/replyto/replyto-chain-integration-test-5-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/replyto/replyto-chain-integration-test-5-flow.xml"});
    }

    @Test
    public void testReplyToIsHonoredInFlowUsingAsyncBlock() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        final Latch flowExecutedLatch = new Latch();
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("replierService");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                flowExecutedLatch.release();
            }
        });
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST_PAYLOAD, muleContext);
        muleMessage.setOutboundProperty("MULE_REPLYTO", (Object)"jms://response");
        client.dispatch("jms://jmsIn1", (MuleMessage)muleMessage);
        flowExecutedLatch.await(5000L, TimeUnit.MILLISECONDS);
        MuleMessage response = client.request("jms://response", 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)EXPECTED_PAYLOAD));
    }
}

