/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.schedule;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.schedule.Scheduler;
import org.springframework.beans.factory.BeanNameAware;

public class MockScheduler
implements Scheduler,
BeanNameAware {
    private AtomicInteger count = new AtomicInteger(0);
    private ScheduledExecutorService executorService;
    private String name;
    private Runnable task;

    public void schedule() throws Exception {
        this.task.run();
    }

    public void setName(String name) {
    }

    public String getName() {
        return this.name;
    }

    public void start() throws MuleException {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.task = new Runnable(){

            @Override
            public void run() {
                MockScheduler.this.count.incrementAndGet();
            }
        };
        this.executorService.scheduleAtFixedRate(this.task, 1000L, 2000L, TimeUnit.MILLISECONDS);
    }

    public void stop() throws MuleException {
        this.executorService.shutdown();
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public int getCount() {
        return this.count.get();
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
    }
}

