/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.security.oauth2;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.security.oauth.BaseOAuth2Manager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.store.InMemoryObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthorizationEventTestCase
extends FunctionalTestCase {
    private static final String payload = "this is the payload";
    private static final String eventId = "the event id";
    private MuleEvent event;
    private TestOAuth2Manager manager;
    private KeyedPoolableObjectFactory<String, OAuth2Adapter> objectFactory = null;
    private OAuth2Adapter adapter;
    private ObjectStore<Serializable> accessTokenObjectStore;
    private DefaultMuleMessage message;

    @Before
    public void setUp() {
        this.objectFactory = (KeyedPoolableObjectFactory)Mockito.mock(KeyedPoolableObjectFactory.class);
        this.adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Initialisable.class, Startable.class, Stoppable.class, Disposable.class, MuleContextAware.class}));
        this.message = new DefaultMuleMessage((Object)payload, muleContext);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.event.getId()).thenReturn((Object)eventId);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        this.accessTokenObjectStore = new InMemoryObjectStore();
        this.manager = (TestOAuth2Manager)((Object)Mockito.spy((Object)((Object)new TestOAuth2Manager(this.objectFactory, this.adapter))));
        this.manager.setAccessTokenObjectStore(this.accessTokenObjectStore);
    }

    protected String getConfigFile() {
        return "org/mule/test/security/oauth/oauth2-authorization-event-test.xml";
    }

    @Test
    public void storeConsumableAuthorizationEvent() throws Exception {
        this.message.setPayload((Object)new ByteArrayInputStream(payload.getBytes()));
        this.manager.storeAuthorizationEvent(this.event);
        Assert.assertEquals((Object)this.message.getPayload(), (Object)payload);
        String key = String.format("%s-authorization-event", eventId);
        Assert.assertTrue((boolean)this.accessTokenObjectStore.contains((Serializable)((Object)key)));
        Assert.assertSame((Object)this.accessTokenObjectStore.retrieve((Serializable)((Object)key)), (Object)this.event);
    }

    @Test
    public void storeSerializableAuthorizationEvent() throws Exception {
        this.manager.storeAuthorizationEvent(this.event);
        Assert.assertEquals((Object)this.message.getPayload(), (Object)payload);
        String key = String.format("%s-authorization-event", eventId);
        Assert.assertTrue((boolean)this.accessTokenObjectStore.contains((Serializable)((Object)key)));
        Assert.assertSame((Object)this.accessTokenObjectStore.retrieve((Serializable)((Object)key)), (Object)this.event);
    }

    @Test(expected=MessagingException.class)
    public void storeNotSerializableAuthorizationEvent() throws Exception {
        this.message.setPayload(new Object());
        this.manager.storeAuthorizationEvent(this.event);
    }

    @Test(expected=MessagingException.class)
    public void storeAuthorizationEventOnFailingOS() throws Exception {
        ObjectStore failingOS = (ObjectStore)Mockito.mock(ObjectStore.class);
        ((ObjectStore)Mockito.doThrow((Throwable)new ObjectStoreException()).when((Object)failingOS)).store((Serializable)Mockito.any(Serializable.class), (Serializable)Mockito.any(Serializable.class));
        this.manager.setAccessTokenObjectStore(failingOS);
        this.manager.storeAuthorizationEvent(this.event);
    }

    @Test
    public void restoreAuthorizationEvent() throws Exception {
        this.storeSerializableAuthorizationEvent();
        MuleEvent restoredEvent = this.manager.restoreAuthorizationEvent(eventId);
        Assert.assertSame((Object)restoredEvent, (Object)this.event);
    }

    @Test(expected=ObjectDoesNotExistException.class)
    public void restoreNotExistentAuthorizationEvent() throws Exception {
        this.manager.restoreAuthorizationEvent(eventId);
    }

    @Test(expected=ObjectStoreException.class)
    public void restoreAuthorizationEventFromFailingObjectStore() throws Exception {
        ObjectStore failingOS = (ObjectStore)Mockito.mock(ObjectStore.class);
        Mockito.when((Object)failingOS.retrieve((Serializable)Mockito.any(Serializable.class))).thenThrow(new Throwable[]{new ObjectStoreException()});
        this.manager.setAccessTokenObjectStore(failingOS);
        this.manager.restoreAuthorizationEvent(eventId);
    }

    private class TestOAuth2Manager
    extends BaseOAuth2Manager<OAuth2Adapter> {
        private final transient Logger logger = LoggerFactory.getLogger(TestOAuth2Manager.class);
        private KeyedPoolableObjectFactory<String, OAuth2Adapter> objectFactory;
        private OAuth2Adapter adapter;

        public TestOAuth2Manager(KeyedPoolableObjectFactory<String, OAuth2Adapter> objectFactory, OAuth2Adapter adapter) {
            this.objectFactory = objectFactory;
            this.adapter = adapter;
            this.setDefaultUnauthorizedConnector(this.adapter);
        }

        protected Logger getLogger() {
            return this.logger;
        }

        protected KeyedPoolableObjectFactory<String, OAuth2Adapter> createPoolFactory(OAuth2Manager<OAuth2Adapter> oauthManager, ObjectStore<Serializable> objectStore) {
            return this.objectFactory;
        }

        protected void fetchCallbackParameters(OAuth2Adapter adapter, String response) {
        }

        protected void setCustomProperties(OAuth2Adapter adapter) {
        }

        protected OAuth2Adapter instantiateAdapter() {
            return this.adapter;
        }
    }
}

