/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.context.notification.TransactionNotification;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.concurrent.Latch;

public class TransactionalElementLifecycleTestCase
extends FunctionalTestCase {
    private static final int TIMEOUT_MILLIS = 5000;
    private static final int POLL_DELAY_MILLIS = 100;
    private List<TransactionNotification> notifications;

    protected String getConfigFile() {
        return "org/mule/test/integration/transaction/transactional-lifecycle-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.notifications = new ArrayList<TransactionNotification>();
    }

    @Test
    public void testInitializeIsCalledInInnerExceptionStrategy() throws Exception {
        muleContext.getNotificationManager().addListener((ServerNotificationListener)new TransactionNotificationListener<TransactionNotification>(){

            public void onNotification(TransactionNotification notification) {
                TransactionalElementLifecycleTestCase.this.notifications.add(notification);
            }
        });
        final Latch endDlqFlowLatch = new Latch();
        LocalMuleClient client = muleContext.getClient();
        FunctionalTestComponent functionalTestComponent = this.getFunctionalTestComponent("dlq-out");
        functionalTestComponent.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                endDlqFlowLatch.release();
            }
        });
        client.send("vm://in", (Object)"message", null, 5000L);
        if (!endDlqFlowLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message wasn't received by dlq flow");
        }
        this.assertNotificationsArrived();
        this.assertApplicationName();
    }

    private void assertApplicationName() {
        for (TransactionNotification notification : this.notifications) {
            Assert.assertThat((Object)notification.getApplicationName(), (Matcher)CoreMatchers.is((Object)muleContext.getConfiguration().getId()));
        }
    }

    private void assertNotificationsArrived() {
        PollingProber pollingProber = new PollingProber(5000L, 100L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)TransactionalElementLifecycleTestCase.this.notifications.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                return true;
            }

            public String describeFailure() {
                return "Notifications did not arrive";
            }
        });
    }
}

