/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction.xa;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.mule.test.integration.transaction.xa.TransactionalTestSetUp;

public class JmsBrokerSetUp
implements TransactionalTestSetUp {
    private final int port;
    private BrokerService broker;
    private final List<AuthenticationUser> users = Lists.newArrayList();

    public JmsBrokerSetUp(int port) {
        this.port = port;
    }

    @Override
    public void initialize() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:" + this.port);
        if (!this.users.isEmpty()) {
            SimpleAuthenticationPlugin authenticationPlugin = new SimpleAuthenticationPlugin(this.users);
            this.broker.setPlugins(new BrokerPlugin[]{authenticationPlugin});
        }
        this.broker.start();
    }

    @Override
    public void finalice() throws Exception {
        try {
            this.broker.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addUser(String username, String password, String groups) {
        this.users.add(new AuthenticationUser(username, password, groups));
    }
}

