/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction.xa;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.mule.test.integration.transaction.xa.TransactionScenarios;
import org.springframework.jms.support.JmsUtils;

public class JmsOutboundMessagesCounter
implements TransactionScenarios.OutboundMessagesCounter {
    private MessageConsumer consumer;
    private boolean initialized;
    private int numberOfMessagesArrived;
    private String brokerUrl;
    private Connection connection;

    public static JmsOutboundMessagesCounter createVerifierForBroker(int port) {
        return new JmsOutboundMessagesCounter("tcp://localhost:" + port);
    }

    private JmsOutboundMessagesCounter(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public void initialize() {
        if (!this.initialized) {
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
            cf.setBrokerURL(this.brokerUrl);
            try {
                this.connection = cf.createConnection();
                this.connection.start();
                Session session = this.connection.createSession(false, 1);
                this.consumer = session.createConsumer((Destination)session.createQueue("out"));
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
            this.initialized = true;
        }
    }

    @Override
    public int numberOfMessagesThatArrived() throws Exception {
        Message message;
        this.initialize();
        while ((message = this.consumer.receive(1000L)) != null) {
            ++this.numberOfMessagesArrived;
        }
        return this.numberOfMessagesArrived;
    }

    @Override
    public void close() {
        JmsUtils.closeMessageConsumer((MessageConsumer)this.consumer);
        JmsUtils.closeConnection((Connection)this.connection);
        this.consumer = null;
        this.initialized = false;
        this.numberOfMessagesArrived = 0;
    }
}

