/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ReplyToHandler;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.AbstractConnector;
import org.mule.transport.DefaultReplyToHandler;

public class ReplyToSerializationTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/integration/transport/reply-to-serialization.xml";
    }

    @Test
    public void testSerialization() throws Exception {
        EndpointBuilder jmsEndpointBuilder = muleContext.getRegistry().lookupEndpointBuilder("jmsEndpoint");
        EndpointBuilder vmEndpointBuilder = muleContext.getRegistry().lookupEndpointBuilder("vmEndpoint");
        EndpointBuilder ajaxEndpointBuilder = muleContext.getRegistry().lookupEndpointBuilder("ajaxEndpoint");
        InboundEndpoint jmsEndpoint = jmsEndpointBuilder.buildInboundEndpoint();
        Connector jmsConnector = jmsEndpoint.getConnector();
        InboundEndpoint vmEndpoint = vmEndpointBuilder.buildInboundEndpoint();
        Connector vmConnector = vmEndpoint.getConnector();
        InboundEndpoint ajaxEndpoint = ajaxEndpointBuilder.buildInboundEndpoint();
        Connector ajaxConnector = ajaxEndpoint.getConnector();
        DefaultReplyToHandler jmsHandler = (DefaultReplyToHandler)((AbstractConnector)jmsConnector).getReplyToHandler((ImmutableEndpoint)jmsEndpoint);
        DefaultReplyToHandler vmHandler = (DefaultReplyToHandler)((AbstractConnector)vmConnector).getReplyToHandler((ImmutableEndpoint)vmEndpoint);
        DefaultReplyToHandler ajaxHandler = (DefaultReplyToHandler)((AbstractConnector)ajaxConnector).getReplyToHandler((ImmutableEndpoint)ajaxEndpoint);
        DefaultReplyToHandler jmsHandler2 = this.serialize((ReplyToHandler)jmsHandler);
        DefaultReplyToHandler vmHandler2 = this.serialize((ReplyToHandler)vmHandler);
        DefaultReplyToHandler ajaxHandler2 = this.serialize((ReplyToHandler)ajaxHandler);
        Assert.assertEquals((Object)jmsHandler.getConnector(), (Object)jmsHandler2.getConnector());
        Assert.assertEquals((Object)vmHandler.getConnector(), (Object)vmHandler2.getConnector());
        Assert.assertEquals((Object)ajaxHandler.getConnector(), (Object)ajaxHandler2.getConnector());
    }

    private DefaultReplyToHandler serialize(ReplyToHandler handler) throws IOException, ClassNotFoundException, MuleException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(handler);
        oos.flush();
        DefaultReplyToHandler serialized = (DefaultReplyToHandler)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        serialized.initAfterDeserialisation(muleContext);
        return serialized;
    }
}

