/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.mule.api.MuleEventContext;
import org.mule.api.model.Model;
import org.mule.api.transport.Connector;
import org.mule.model.seda.SedaModel;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleDerbyTestUtils;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;

public abstract class AbstractJdbcFunctionalTestCase
extends AbstractMuleContextTestCase {
    public static final String DEFAULT_IN_URI = "jdbc://getTest?type=1";
    public static final String DEFAULT_OUT_URI = "jdbc://writeTest?type=2";
    public static final String CONNECTOR_NAME = "testConnector";
    public static final String DEFAULT_MESSAGE = "Test Message";
    public static final String SQL_READ = "SELECT ID, TYPE, DATA, ACK, RESULT FROM TEST WHERE TYPE = #[type] AND ACK IS NULL";
    public static final String SQL_ACK = "UPDATE TEST SET ACK = #[NOW] WHERE ID = #[id] AND TYPE = #[type] AND DATA = #[data]";
    public static final String SQL_WRITE = "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES(#[type], #[payload], NULL, NULL)";
    public static String EMBEDDED_CONNECTION_STRING;
    public static final String EMBEDDED_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    public static String CLIENT_CONNECTION_STRING;
    public static final String CLIENT_DRIVER_NAME = "org.apache.derby.jdbc.ClientDriver";
    protected Connector connector;
    protected Model model;
    protected DataSource dataSource;
    private static boolean derbySetupDone;

    @BeforeClass
    public static void startDatabase() throws Exception {
        if (!derbySetupDone) {
            String dbName = MuleDerbyTestUtils.loadDatabaseName((String)"derby.properties", (String)"database.name");
            MuleDerbyTestUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
            EMBEDDED_CONNECTION_STRING = "jdbc:derby:" + dbName;
            CLIENT_CONNECTION_STRING = "jdbc:derby://localhost:1527/" + dbName + ";create=true";
            derbySetupDone = true;
        }
    }

    @AfterClass
    public static void stopDatabase() throws SQLException {
        MuleDerbyTestUtils.stopDatabase();
    }

    protected void doSetUp() throws Exception {
        SedaModel model = new SedaModel();
        model.setName("main");
        model.getPoolingProfile().setInitialisationPolicy(1);
        muleContext.getRegistry().registerModel((Model)model);
        this.connector = this.createConnector();
        muleContext.getRegistry().registerConnector(this.connector);
        this.emptyTable();
    }

    protected void emptyTable() throws Exception {
        try {
            this.execSqlUpdate("DELETE FROM TEST");
        }
        catch (Exception e) {
            this.execSqlUpdate("CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,TYPE INTEGER,DATA VARCHAR(255),ACK TIMESTAMP,RESULT VARCHAR(255))");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execSqlUpdate(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            int n = new QueryRunner().update(con, sql);
            return n;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] execSqlQuery(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            Object[] objectArray = (Object[])new QueryRunner().query(con, sql, (ResultSetHandler)new ArrayHandler());
            return objectArray;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }

    public Connection getConnection() throws Exception {
        DataSource dataSource = this.getDataSource();
        if (dataSource instanceof DataSource) {
            return dataSource.getConnection();
        }
        return ((XADataSource)((Object)dataSource)).getXAConnection().getConnection();
    }

    public DataSource getDataSource() throws Exception {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    public Connector createConnector() throws Exception {
        JdbcConnector connector = new JdbcConnector(muleContext);
        connector.setDataSource(this.getDataSource());
        connector.setName(CONNECTOR_NAME);
        connector.getDispatcherThreadingProfile().setDoThreading(false);
        connector.setPollingFrequency(5000L);
        HashMap<String, String> queries = new HashMap<String, String>();
        queries.put("getTest", SQL_READ);
        queries.put("getTest.ack", SQL_ACK);
        queries.put("writeTest", SQL_WRITE);
        connector.setQueries(queries);
        return connector;
    }

    protected String getInDest() {
        return DEFAULT_IN_URI;
    }

    protected String getOutDest() {
        return DEFAULT_OUT_URI;
    }

    protected DataSource createDataSource() throws Exception {
        return this.createEmbeddedDataSource();
    }

    protected DataSource createEmbeddedDataSource() throws Exception {
        StandardDataSource ds = new StandardDataSource();
        ds.setDriverName(EMBEDDED_DRIVER_NAME);
        ds.setUrl(EMBEDDED_CONNECTION_STRING);
        return ds;
    }

    protected DataSource createClientDataSource() throws Exception {
        StandardDataSource ds = new StandardDataSource();
        ds.setDriverName(CLIENT_DRIVER_NAME);
        ds.setUrl(CLIENT_CONNECTION_STRING);
        return ds;
    }

    static {
        derbySetupDone = false;
    }

    public static class JdbcFunctionalTestComponent
    extends FunctionalTestComponent {
        public Object onCall(MuleEventContext context) throws Exception {
            if (this.getEventCallback() != null) {
                this.getEventCallback().eventReceived(context, (Object)this);
            }
            Map map = (Map)context.getMessage().getPayload();
            return map.get("data") + " Received";
        }
    }
}

