/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.jms;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;

public class JmsRequestResponseReplyToTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public JmsRequestResponseReplyToTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/transport/jms/jms-request-response-reply-to-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/transport/jms/jms-request-response-reply-to-config-flow.xml"});
    }

    @Test
    public void testStaticHttpOutboundRepliesToJmsInbound() throws Exception {
        this.doTest("jms://jms.static");
    }

    @Test
    public void testDynamicHttpOutboundRepliesToJmsInbound() throws Exception {
        this.doTest("jms://jms.dynamic");
    }

    private void doTest(String jmsRequestUrl) throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(jmsRequestUrl, (Object)("localhost:" + this.dynamicPort.getNumber() + "/test"), null);
        Assert.assertNotNull((Object)result);
        Assert.assertNull((Object)result.getExceptionPayload());
        Assert.assertFalse((String)"Response payload shouldn't be null", (boolean)(result.getPayload() instanceof NullPayload));
    }
}

