/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.jms;

import java.util.Arrays;
import java.util.Collection;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class QosHeadersTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/providers/jms/qosheaders-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/providers/jms/qosheaders-test-flow.xml"});
    }

    public QosHeadersTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testQosHeadersHonored() throws JMSException {
        String producerQueue = "test.in.kind";
        String consumerQueue = "test.out.kind";
        this.doSendReceiveCycle(producerQueue, consumerQueue, true);
    }

    @Test
    public void testQosHeadersNotHonored() throws JMSException {
        String producerQueue = "test.in.selfish";
        String consumerQueue = "test.out.selfish";
        this.doSendReceiveCycle(producerQueue, consumerQueue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendReceiveCycle(String producerQueue, String consumerQueue, boolean honorProperties) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
        Connection producerConnection = null;
        Connection consumerConnection = null;
        try {
            producerConnection = connectionFactory.createConnection();
            producerConnection.start();
            Session producerSession = producerConnection.createSession(false, 1);
            Queue producerDestination = producerSession.createQueue(producerQueue);
            MessageProducer producer = producerSession.createProducer((Destination)producerDestination);
            consumerConnection = connectionFactory.createConnection();
            consumerConnection.start();
            Session consumerSession = consumerConnection.createSession(false, 1);
            Queue consumerDestination = consumerSession.createQueue(consumerQueue);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerDestination);
            String message = "QoS Headers Propagation Test";
            TextMessage textMessage = producerSession.createTextMessage(message);
            producer.setPriority(7);
            producer.setDeliveryMode(2);
            producer.send((Message)textMessage);
            Message response = consumer.receive(10000L);
            if (honorProperties) {
                this.performHeadersHonoredAssertions(response);
            } else {
                this.performHeadersNotHonoredAssertions(response);
            }
        }
        finally {
            try {
                if (consumerConnection != null) {
                    consumerConnection.close();
                }
            }
            catch (JMSException jMSException) {}
            try {
                if (producerConnection != null) {
                    producerConnection.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    protected void performHeadersHonoredAssertions(Message response) throws JMSException {
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"JMS Priority should've been honored.", (long)7L, (long)response.getJMSPriority());
        Assert.assertEquals((String)"JMS Delivery mode should've been honored", (long)2L, (long)response.getJMSDeliveryMode());
    }

    protected void performHeadersNotHonoredAssertions(Message response) throws JMSException {
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"JMS Priority should have not been honored.", (long)4L, (long)response.getJMSPriority());
        Assert.assertEquals((String)"JMS Delivery mode should have not been honored", (long)1L, (long)response.getJMSDeliveryMode());
    }
}

