/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.work;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.service.Service;
import org.mule.construct.Flow;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.concurrent.Latch;

public class GracefulShutdownTimeoutTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/work/graceful-shutdown-timeout-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/work/graceful-shutdown-timeout-flow.xml"});
    }

    public GracefulShutdownTimeoutTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    @Test
    public void testGracefulShutdownTimeout() throws Exception {
        final Latch latch = new Latch();
        FlowConstruct service = muleContext.getRegistry().lookupFlowConstruct("TestService");
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent(service);
        testComponent.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                Thread.sleep(5500L);
                latch.countDown();
            }
        });
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            ((Flow)service).process(GracefulShutdownTimeoutTestCase.getTestEvent((Object)"test"));
            Thread.sleep(200L);
            ((Flow)service).dispose();
            Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        } else {
            ((Service)service).dispatchEvent(GracefulShutdownTimeoutTestCase.getTestEvent((Object)"test"));
            Thread.sleep(200L);
            ((Service)service).dispose();
            Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        }
    }
}

