/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.properties;

import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpVmSessionPropertiesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    protected String getConfigFile() {
        return "org/mule/test/properties/session-properties-http-vm-config.xml";
    }

    @Test
    public void testPropertiesFromHttpToVm() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        Map properties = Collections.emptyMap();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort1.getNumber() + "/http-inbound-flow", (MuleMessage)new DefaultMuleMessage((Object)"some message", properties, muleContext));
        Assert.assertThat((Object)message, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message.getExceptionPayload(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testPropertiesFromVmToHttp() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        Map properties = Collections.emptyMap();
        MuleMessage message = client.send("vm://vm-inbound-flow", (MuleMessage)new DefaultMuleMessage((Object)"some message", properties, muleContext));
        Assert.assertThat((Object)message, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message.getExceptionPayload(), (Matcher)IsNull.nullValue());
    }
}

