/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.reconnection;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.config.spring.AbstractSchemaValidationTestCase;
import org.xml.sax.SAXException;

public class InvalidReconnectionStrategyTestCase
extends AbstractSchemaValidationTestCase {
    private static final String ERROR_MESSAGE = "Invalid content was found starting with element 'reconnect'";

    @Test
    public void testInvalidReconnectStrategyWithinInboundEndpoint() throws Exception {
        this.addSchema("http://www.mulesoft.org/schema/mule/ftp", "META-INF/mule-ftp.xsd");
        try {
            this.doTest("org/mule/test/reconnection/invalid-reconnection-within-inbound-endpoint-config.xml");
            Assert.fail((String)"SaxException must be triggered, because it's an invalid configuration.");
        }
        catch (SAXException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ERROR_MESSAGE));
        }
    }

    @Test
    public void testInvalidReconnectStrategyWithinOutboundEndpoint() throws Exception {
        this.addSchema("http://www.mulesoft.org/schema/mule/ftp", "META-INF/mule-ftp.xsd");
        try {
            this.doTest("org/mule/test/reconnection/invalid-reconnection-within-outbound-endpoint-config.xml");
            Assert.fail((String)"SaxException must be triggered, because it's an invalid configuration.");
        }
        catch (SAXException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ERROR_MESSAGE));
        }
    }
}

