/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.tck.junit4.FunctionalTestCase;

public class FirstSuccessfulTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "first-successful-test.xml";
    }

    @Test
    public void testFirstSuccessful() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://input", (Object)"XYZ", null);
        Assert.assertEquals((Object)"XYZ is a string", (Object)response.getPayloadAsString());
        response = client.send("vm://input", (Object)9, null);
        Assert.assertEquals((Object)"9 is an integer", (Object)response.getPayloadAsString());
        response = client.send("vm://input", (Object)42L, null);
        Assert.assertEquals((Object)"42 is a number", (Object)response.getPayloadAsString());
        response = client.send("vm://input", (Object)Boolean.TRUE, null);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getExceptionPayload());
        Assert.assertEquals(CouldNotRouteOutboundMessageException.class, response.getExceptionPayload().getException().getClass());
    }

    @Test
    public void testFirstSuccessfulWithExpression() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://input2", (Object)"XYZ", null);
        Assert.assertEquals((Object)"XYZ is a string", (Object)response.getPayloadAsString());
    }

    @Test
    public void testFirstSuccessfulWithExpressionAllFail() throws Exception {
        MuleMessage response = muleContext.getClient().send("vm://input3", (Object)"XYZ", null);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getExceptionPayload());
        Assert.assertEquals(CouldNotRouteOutboundMessageException.class, response.getExceptionPayload().getException().getClass());
    }

    @Test
    public void testFirstSuccessfulWithOneWayEndpoints() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://input4.in", (Object)"Test Message", null);
        MuleMessage response = client.request("vm://output4.out", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Test Message", (Object)response.getPayload());
    }
}

