/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.tck;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.MessageExchangePattern;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.TestNonBlockingProcessor;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.functional.ResponseAssertionMessageProcessor;
import org.mule.test.tck.AssertionMessageProcessorTestCase;

public class ResponseAssertionMessageProcessorTestCase
extends AssertionMessageProcessorTestCase {
    private TestNonBlockingProcessor testNonBlockingProcessor;

    @Before
    public void before() throws InitialisationException {
        this.testNonBlockingProcessor = new TestNonBlockingProcessor();
        this.testNonBlockingProcessor.initialise();
    }

    @After
    public void after() {
        this.testNonBlockingProcessor.dispose();
    }

    protected ResponseAssertionMessageProcessor createAssertionMessageProcessor() {
        ResponseAssertionMessageProcessor mp = new ResponseAssertionMessageProcessor();
        mp.setListener((MessageProcessor)new SensingNullMessageProcessor());
        return mp;
    }

    @Test
    public void responseProcess() throws Exception {
        Mockito.when((Object)this.mockEvent.isAllowNonBlocking()).thenReturn((Object)false);
        Mockito.when((Object)this.mockEvent.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        ResponseAssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setListener((MessageProcessor)this.testNonBlockingProcessor);
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setResponseExpression("trueExpression");
        asp.setCount(1);
        asp.setResponseCount(1);
        asp.setResponseSameThread(false);
        asp.start();
        asp.process(this.mockEvent);
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.responseExpressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
        Assert.assertFalse((boolean)asp.responseCountFailOrNullEvent());
    }

    @Test
    public void responseProcessNonBlocking() throws Exception {
        Mockito.when((Object)this.mockEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.mockEvent.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        ResponseAssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setListener((MessageProcessor)this.testNonBlockingProcessor);
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setResponseExpression("trueExpression");
        asp.setCount(1);
        asp.setResponseCount(1);
        asp.setResponseSameThread(false);
        asp.start();
        asp.process(this.mockEvent);
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.responseExpressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
        Assert.assertFalse((boolean)asp.responseCountFailOrNullEvent());
    }
}

