/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.routing.response;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.routing.requestreply.AbstractAsyncRequestReplyRequester;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.util.store.SimpleMemoryObjectStore;

public class ResponseAggregatorTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/usecases/routing/response/response-router-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/usecases/routing/response/response-router-flow.xml"});
    }

    public ResponseAggregatorTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSyncResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HttpRequestOptions httpRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
        MuleMessage message = client.send("http://localhost:28081", ResponseAggregatorTestCase.getTestMuleMessage((Object)"request"), (OperationOptions)httpRequestOptions);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Received: request", (Object)new String(message.getPayloadAsBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseEventsCleanedUp() throws Exception {
        RelaxedAsyncReplyMP mp = new RelaxedAsyncReplyMP();
        try {
            MuleEvent event = ResponseAggregatorTestCase.getTestEvent((Object)"message1");
            MuleMessage message = event.getMessage();
            String id = message.getUniqueId();
            message.setCorrelationId(id);
            message.setCorrelationGroupSize(1);
            SensingNullMessageProcessor listener = this.getSensingNullMessageProcessor();
            mp.setListener((MessageProcessor)listener);
            mp.setReplySource(listener.getMessageSource());
            mp.process(event);
            Map<String, MuleEvent> responseEvents = mp.getResponseEvents();
            Assert.assertTrue((String)"Response events should be cleaned up.", (boolean)responseEvents.isEmpty());
        }
        finally {
            mp.stop();
        }
    }

    private static final class RelaxedAsyncReplyMP
    extends AbstractAsyncRequestReplyRequester {
        private RelaxedAsyncReplyMP() throws MuleException {
            this.store = new SimpleMemoryObjectStore();
            this.name = "asyncReply";
            this.start();
        }

        public Map<String, MuleEvent> getResponseEvents() {
            return this.responseEvents;
        }
    }
}

