/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.Assert;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.module.launcher.application.Application;
import org.mule.test.infrastructure.deployment.AbstractFakeMuleServerTestCase;

public class LogConfigurationTestCase
extends AbstractFakeMuleServerTestCase {
    public static final String APP_NAME = "app1";
    public static final String DOMAIN_NAME = "domain";

    @Test
    public void defaultAppLoggingConfigurationOnlyLogsOnApplicationLogFile() throws IOException, MuleException {
        this.muleServer.start();
        this.muleServer.deploy("/log/emptyApp.zip", APP_NAME);
        this.ensureOnlyDefaultAppender();
    }

    @Test
    public void defaultAppInDomainLoggingConfigurationOnlyLogsOnApplicationLogFile() throws IOException, MuleException {
        this.muleServer.start();
        this.muleServer.deployDomainFromClasspathFolder("log/empty-domain", DOMAIN_NAME);
        this.muleServer.deploy("/log/appInDomain.zip", APP_NAME);
        this.ensureOnlyDefaultAppender();
    }

    @Test
    public void honorLog4jConfigFileForApp() throws IOException, MuleException {
        this.muleServer.start();
        this.muleServer.deploy("/log/appWithLog4j.zip", APP_NAME);
        this.ensureArtifactAppender("consoleForApp");
    }

    @Test
    public void honorLog4jConfigFileForAppInDomain() throws IOException, MuleException {
        this.muleServer.start();
        this.muleServer.deployDomainFromClasspathFolder("log/empty-domain-with-log4j", DOMAIN_NAME);
        this.muleServer.deploy("/log/appInDomain.zip", APP_NAME);
        this.ensureArtifactAppender("consoleForDomain");
    }

    private void ensureOnlyDefaultAppender() {
        Logger logger = this.getRootLoggerForApp(APP_NAME);
        Assert.assertEquals((int)1, (int)this.appendersCount(logger));
        Assert.assertEquals((int)1, (int)this.selectByClass(logger, FileAppender.class).size());
        FileAppender fileAppender = (FileAppender)this.selectByClass(logger, FileAppender.class).get(0);
        Assert.assertEquals((String)"defaultFileAppender", (String)fileAppender.getName());
        Assert.assertTrue((boolean)fileAppender.getFile().contains(String.format("mule-app-%s.log", APP_NAME)));
    }

    private void ensureArtifactAppender(String appenderName) {
        Logger logger = this.getRootLoggerForApp(APP_NAME);
        Assert.assertEquals((Object)Level.DEBUG, (Object)logger.getEffectiveLevel());
        Assert.assertEquals((int)1, (int)this.appendersCount(logger));
        Assert.assertEquals((int)1, (int)this.selectByClass(logger, ConsoleAppender.class).size());
        Assert.assertEquals((String)appenderName, (String)this.selectByClass(logger, ConsoleAppender.class).get(0).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger getRootLoggerForApp(String appName) {
        Application app = this.muleServer.findApplication(appName);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(app.getMuleContext().getExecutionClassLoader());
            Logger logger = Logger.getLogger(app.getClass()).getLoggerRepository().getRootLogger();
            return logger;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private List<Appender> selectByClass(Logger root, Class<?> appenderClass) {
        ArrayList<Appender> filteredAppenders = new ArrayList<Appender>();
        Enumeration appenders = root.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!appenderClass.isAssignableFrom(appender.getClass())) continue;
            filteredAppenders.add(appender);
        }
        return filteredAppenders;
    }

    private int appendersCount(Logger root) {
        return this.selectByClass(root, Appender.class).size();
    }
}

