/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.annotations.param;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.expression.RequiredValueException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.util.ExceptionUtils;

public class InboundHeadersAnnotationTestCase
extends AbstractServiceAndFlowTestCase {
    private Map<String, Object> props;

    public InboundHeadersAnnotationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/annotations/inbound-headers-annotation-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/annotations/inbound-headers-annotation-flow.xml"});
    }

    public void doSetUp() throws Exception {
        super.doSetUp();
        this.props = new HashMap<String, Object>(3);
        this.props.put("foo", "fooValue");
        this.props.put("bar", "barValue");
        this.props.put("baz", "bazValue");
    }

    @Test
    public void testSingleHeader() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://header", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertEquals((Object)"fooValue", (Object)message.getPayload());
    }

    @Test
    public void testSingleHeaderOptional() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headerOptional", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertEquals((Object)"faz not set", (Object)message.getPayload());
    }

    @Test
    public void testSingleHeaderWithType() throws Exception {
        Apple apple = new Apple();
        this.props.put("apple", apple);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headerWithType", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertEquals((Object)apple, (Object)message.getPayload());
    }

    @Test
    public void testSingleHeaderWithBaseType() throws Exception {
        Apple apple = new Apple();
        this.props.put("apple", apple);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headerWithBaseType", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertEquals((Object)apple, (Object)message.getPayload());
    }

    @Test
    public void testMapHeaders() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headers", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"fooValue", result.get("foo"));
        Assert.assertEquals((Object)"barValue", result.get("bar"));
        Assert.assertNull(result.get("baz"));
    }

    @Test
    public void testMapHeadersMissing() throws Exception {
        this.props.remove("foo");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headers", null, null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(RequiredValueException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testMapSingleHeader() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://singleHeaderMap", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"fooValue", result.get("foo"));
        Assert.assertNull(result.get("bar"));
        Assert.assertNull(result.get("baz"));
    }

    @Test
    public void testMapHeadersOptional() throws Exception {
        this.props.remove("baz");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersOptional", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"fooValue", result.get("foo"));
        Assert.assertEquals((Object)"barValue", result.get("bar"));
        Assert.assertNull(result.get("baz"));
    }

    @Test
    public void testMapHeadersAllOptional() throws Exception {
        this.props.clear();
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersAllOptional", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testMapHeadersUnmodifiable() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersUnmodifiable", null, this.props);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testMapHeadersAll() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersAll", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertTrue((result.size() >= 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"fooValue", result.get("foo"));
        Assert.assertEquals((Object)"barValue", result.get("bar"));
        Assert.assertEquals((Object)"bazValue", result.get("baz"));
    }

    @Test
    public void testMapHeadersWildcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersWildcard", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        this.printResult(result);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)"vm://headersWildcard", result.get("MULE_ENDPOINT"));
        Assert.assertTrue((boolean)result.keySet().contains("MULE_SESSION"));
    }

    @Test
    public void testMapHeadersMultiWildcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersMultiWildcard", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        this.printResult(result);
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertEquals((Object)"vm://headersMultiWildcard", result.get("MULE_ENDPOINT"));
        Assert.assertTrue((boolean)result.keySet().contains("MULE_SESSION"));
        Assert.assertEquals(result.get("bar"), (Object)"barValue");
        Assert.assertEquals(result.get("baz"), (Object)"bazValue");
    }

    @Test
    public void testMapHeadersWithGenerics() throws Exception {
        this.props.put("apple", new Apple());
        this.props.put("banana", new Banana());
        this.props.put("orange", new Orange());
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersWithGenerics", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)new Apple(), result.get("apple"));
        Assert.assertEquals((Object)new Orange(), result.get("orange"));
        Assert.assertNull(result.get("banana"));
    }

    @Test
    public void testListHeaders() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersList", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
        Assert.assertTrue((boolean)result.contains("bazValue"));
    }

    @Test
    public void testListHeadersWithOptional() throws Exception {
        this.props.remove("baz");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListOptional", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
    }

    @Test
    public void testListHeadersWithMissing() throws Exception {
        this.props.remove("bar");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListOptional", null, this.props);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(RequiredValueException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testSingleListHeader() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://singleHeaderList", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("fooValue"));
    }

    @Test
    public void testListHeadersUnmodifiable() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListUnmodifiable", null, this.props);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testListHeadersAll() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListAll", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertTrue((result.size() >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
        Assert.assertTrue((boolean)result.contains("bazValue"));
    }

    @Test
    public void testMapHeadersListAllOptional() throws Exception {
        this.props.clear();
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListAllOptional", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testListHeadersWilcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListWildcard", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        this.printResult(result);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("vm://headersListWildcard"));
    }

    @Test
    public void testListHeadersMultiWilcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListMultiWildcard", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        this.printResult(result);
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("vm://headersListMultiWildcard"));
        Assert.assertTrue((boolean)result.contains("barValue"));
        Assert.assertTrue((boolean)result.contains("bazValue"));
    }

    @Test
    public void testListHeadersWithGenerics() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        this.props.put("apple", apple);
        this.props.put("banana", banana);
        this.props.put("orange", orange);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://headersListWithGenerics", null, this.props);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(apple));
        Assert.assertTrue((boolean)result.contains(orange));
        Assert.assertFalse((boolean)result.contains(banana));
    }

    public void printResult(List<?> result) {
        for (int i = 0; i < result.size(); ++i) {
            System.out.println("result #" + i + ": " + result.get(i));
        }
    }

    public void printResult(Map<?, ?> result) {
        Set<?> keys = result.keySet();
        Iterator<?> keyIter = keys.iterator();
        System.out.println("The map contains the following associations:");
        while (keyIter.hasNext()) {
            Object key = keyIter.next();
            Object value = result.get(key);
            System.out.println("   (" + key + "," + value + ")");
        }
    }
}

