/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.annotations.param;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.ExceptionUtils;
import org.mule.util.StringDataSource;

public class MixedAnnotationsTestCase
extends AbstractServiceAndFlowTestCase {
    private MuleMessage muleMessage;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/annotations/mixed-annotations-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/annotations/mixed-annotations-flow.xml"});
    }

    public MixedAnnotationsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    public void doSetUp() throws Exception {
        super.doSetUp();
        HashMap<String, String> props = new HashMap<String, String>(3);
        props.put("foo", "fooValue");
        props.put("bar", "barValue");
        props.put("baz", "bazValue");
        this.muleMessage = new DefaultMuleMessage((Object)"test", props, muleContext);
        try {
            this.muleMessage.addOutboundAttachment("foo", new DataHandler((DataSource)new StringDataSource("fooValue")));
            this.muleMessage.addOutboundAttachment("bar", new DataHandler((DataSource)new StringDataSource("barValue")));
            this.muleMessage.addOutboundAttachment("baz", new DataHandler((DataSource)new StringDataSource("bazValue")));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testProcessAllAnnotated() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://allAnnotated", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"test", result.get("payload"));
        Assert.assertNotNull(result.get("inboundHeaders"));
        Map headers = (Map)result.get("inboundHeaders");
        Assert.assertEquals((long)2L, (long)headers.size());
        Assert.assertEquals((Object)"fooValue", headers.get("foo"));
        Assert.assertEquals((Object)"barValue", headers.get("bar"));
        Assert.assertNotNull(result.get("inboundAttachments"));
        Map attachments = (Map)result.get("inboundAttachments");
        Assert.assertEquals((long)3L, (long)attachments.size());
        Assert.assertNotNull(attachments.get("foo"));
        Assert.assertNotNull(attachments.get("bar"));
        Assert.assertNotNull(attachments.get("baz"));
    }

    @Test
    public void testPayloadNotAnnotated() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://someAnnotated", this.muleMessage);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(IllegalArgumentException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }
}

