/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.collections.map.HashedMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.IOUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSchemaValidationTestCase
extends AbstractMuleTestCase {
    public static final String SEPARATOR = " ";
    protected Map schemas = new HashedMap();

    @Before
    public void setUpSchemas() {
        this.addSchema("http://www.mulesoft.org/schema/mule/core", "META-INF/mule.xsd");
    }

    protected void addSchema(String name, String location) {
        this.schemas.put(name, location);
    }

    protected Source[] getSchemasAsSources() throws IOException {
        Source[] sources = new Source[this.schemas.size()];
        int index = 0;
        for (String name : this.schemas.keySet()) {
            String location = (String)this.schemas.get(name);
            sources[index++] = this.load(location);
        }
        return sources;
    }

    protected void doTest(String config) throws SAXException, IOException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            Schema schema = schemaFactory.newSchema(this.getSchemasAsSources());
            schema.newValidator().validate(this.load(config));
        }
        catch (SAXParseException ex) {
            System.err.println(MessageFormat.format("SAX parsing exception occurs at line {0}, column {1}", ex.getLineNumber(), ex.getColumnNumber()));
            throw ex;
        }
    }

    protected Source load(String name) throws IOException {
        InputStream stream = IOUtils.getResourceAsStream((String)name, ((Object)((Object)this)).getClass());
        Assert.assertNotNull((String)("Cannot load " + name), (Object)stream);
        return new StreamSource(stream);
    }

    @Test
    public void testSchemaLocations() throws IOException {
        for (String name : this.schemas.keySet()) {
            String location = (String)this.schemas.get(name);
            this.logger.debug((Object)("checking " + location + " for " + name));
            InputStream stream = IOUtils.getResourceAsStream((String)location, ((Object)((Object)this)).getClass());
            Assert.assertNotNull((String)("Cannot load " + location + " for " + name), (Object)stream);
            stream.close();
        }
    }
}

