/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.context.notification.ServerNotification;
import org.mule.context.notification.NotificationLogger;
import org.mule.context.notification.RestrictedNode;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public abstract class AbstractNotificationTestCase
extends AbstractServiceAndFlowTestCase {
    private NotificationLogger notificationLogger;

    public AbstractNotificationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public final void testNotifications() throws Exception {
        this.doTest();
        this.notificationLogger = (NotificationLogger)muleContext.getRegistry().lookupObject("notificationLogger");
        muleContext.dispose();
        Thread.sleep(2000L);
        this.logNotifications();
        RestrictedNode spec = this.getSpecification();
        this.validateSpecification(spec);
        this.assertExpectedNotifications(spec);
    }

    public abstract void doTest() throws Exception;

    public abstract RestrictedNode getSpecification();

    public abstract void validateSpecification(RestrictedNode var1) throws Exception;

    protected void logNotifications() {
        this.logger.info((Object)("Number of notifications: " + this.notificationLogger.getNotifications().size()));
        for (ServerNotification notification : this.notificationLogger.getNotifications()) {
            this.logger.info((Object)notification);
        }
    }

    protected void assertExpectedNotifications(RestrictedNode spec) {
        for (ServerNotification notification : this.notificationLogger.getNotifications()) {
            switch (spec.match(notification)) {
                case 0: {
                    break;
                }
                case 1: {
                    Assert.fail((String)("Could not match " + notification));
                    break;
                }
                case 2: {
                    Assert.fail((String)("Extra notification: " + notification));
                }
            }
        }
        if (!spec.isExhausted()) {
            Assert.fail((String)("Specification not exhausted: " + spec.getAnyRemaining()));
        }
    }

    protected void verifyAllNotifications(RestrictedNode spec, Class<?> clazz, int from, int to) {
        for (int action = from; action <= to; ++action) {
            if (spec.contains(clazz, action)) continue;
            Assert.fail((String)("Specification missed action " + action + " for class " + clazz));
        }
    }

    protected void verifyNotification(RestrictedNode spec, Class<?> clazz, int action) {
        if (!spec.contains(clazz, action)) {
            Assert.fail((String)("Specification missed action " + action + " for class " + clazz));
        }
    }
}

