/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.ComponentMessageNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.service.Service;
import org.mule.component.simple.EchoComponent;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ComponentMessageNotificationNoXMLTestCase
extends AbstractMuleContextTestCase {
    protected Service service;
    protected ServerNotificationManager manager;
    protected ComponentListener componentListener;

    public ComponentMessageNotificationNoXMLTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        ServerNotificationManager notificationManager = new ServerNotificationManager();
        notificationManager.setNotificationDynamic(true);
        notificationManager.addInterfaceToType(ComponentMessageNotificationListener.class, ComponentMessageNotification.class);
        contextBuilder.setNotificationManager(notificationManager);
    }

    protected void doSetUp() throws Exception {
        this.setDisposeContextPerClass(true);
        this.componentListener = new ComponentListener();
        this.service = ComponentMessageNotificationNoXMLTestCase.getTestService((String)"seda", EchoComponent.class);
        if (!muleContext.isStarted()) {
            muleContext.start();
        }
    }

    @Test
    public void testComponentNotificationNotRegistered() throws Exception {
        Assert.assertFalse((boolean)this.componentListener.isNotified());
        this.service.sendEvent(MuleTestUtils.getTestEvent((Object)"test data", (MuleContext)muleContext));
        Assert.assertFalse((boolean)this.componentListener.isNotified());
        Assert.assertFalse((boolean)this.componentListener.isBefore());
        Assert.assertFalse((boolean)this.componentListener.isAfter());
    }

    @Test
    public void testComponentNotification() throws Exception {
        muleContext.registerListener((ServerNotificationListener)this.componentListener);
        Assert.assertFalse((boolean)this.componentListener.isNotified());
        this.service.sendEvent(MuleTestUtils.getTestEvent((Object)"test data", (MuleContext)muleContext));
        Thread.sleep(100L);
        Assert.assertTrue((boolean)this.componentListener.isNotified());
        Assert.assertTrue((boolean)this.componentListener.isBefore());
        Assert.assertTrue((boolean)this.componentListener.isAfter());
    }

    class ComponentListener
    implements ComponentMessageNotificationListener {
        private ServerNotification notification = null;
        private boolean before = false;
        private boolean after = false;

        ComponentListener() {
        }

        public void onNotification(ServerNotification notification) {
            this.notification = notification;
            Assert.assertEquals(ComponentMessageNotification.class, notification.getClass());
            Assert.assertTrue((boolean)(notification.getSource() instanceof MuleMessage));
            Assert.assertNotNull((Object)((ComponentMessageNotification)notification).getServiceName());
            if (notification.getAction() == 1401) {
                this.before = true;
            } else if (notification.getAction() == 1402) {
                this.after = true;
            }
        }

        public boolean isNotified() {
            return null != this.notification;
        }

        public boolean isBefore() {
            return this.before;
        }

        public boolean isAfter() {
            return this.after;
        }
    }
}

