/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.simple.ObjectToString;

public class HttpReturnsJaxbObject5531TestCase
extends AbstractServiceAndFlowTestCase {
    private static final String ZIP_RESPONSE = "<?xml version='1.0' encoding='utf-8'?><soap:Envelope xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:xsd='http://www.w3.org/2001/XMLSchema'><soap:Body><GetCityWeatherByZIPResponse xmlns='http://ws.cdyne.com/WeatherWS/'><GetCityWeatherByZIPResult><Success>true</Success><ResponseText>City Found</ResponseText><State>GA</State><City>Roswell</City><WeatherStationCity>Marietta</WeatherStationCity><WeatherID>1</WeatherID><Description>Thunder Storms</Description><Temperature>79</Temperature><RelativeHumidity>57</RelativeHumidity><Wind>S8</Wind><Pressure>29.91R</Pressure><Visibility /><WindChill /><Remarks /></GetCityWeatherByZIPResult></GetCityWeatherByZIPResponse></soap:Body></soap:Envelope>";
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/issues/http-returns-jaxb-object-mule-5531-test.xml"}});
    }

    public HttpReturnsJaxbObject5531TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testGetWeather() throws Exception {
        String testUrl = "http://localhost:" + this.port1.getNumber() + "/test/weather";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(testUrl, (Object)"hello", null);
        Assert.assertNotNull((Object)response);
        String stringResponse = (String)new ObjectToString().transform((Object)response, "UTF-8");
        Assert.assertTrue((boolean)stringResponse.contains("<Success>true</Success>"));
    }

    public static class WeatherReport
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            return HttpReturnsJaxbObject5531TestCase.ZIP_RESPONSE;
        }
    }
}

