/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ManySendsMule1758TestCase
extends AbstractServiceAndFlowTestCase {
    private static int NUM_MESSAGES = 3000;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/issues/many-sends-mule-1758-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/issues/many-sends-mule-1758-test-flow.xml"});
    }

    public ManySendsMule1758TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSingleSend() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://s-in", (Object)"Marco", null);
        Assert.assertNotNull((String)"Response is null", (Object)response);
        Assert.assertEquals((Object)"Polo", (Object)response.getPayload());
    }

    @Test
    public void testManySends() throws Exception {
        long then = System.currentTimeMillis();
        LocalMuleClient client = muleContext.getClient();
        for (int i = 0; i < NUM_MESSAGES; ++i) {
            this.logger.debug((Object)("Message " + i));
            MuleMessage response = client.send("vm://s-in", (Object)"Marco", null);
            Assert.assertNotNull((String)"Response is null", (Object)response);
            Assert.assertEquals((Object)"Polo", (Object)response.getPayload());
        }
        long now = System.currentTimeMillis();
        this.logger.info((Object)("Total time " + (double)(now - then) / 1000.0 + "s; per message " + (double)(now - then) / (1.0 * (double)NUM_MESSAGES) + "ms"));
    }
}

