/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractMessageTransformer;

public class MessageRootIdPropagationTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/issues/message-root-id.xml";
    }

    @Test
    public void testRootIDs() throws Exception {
        RootIDGatherer.initialize();
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"Hello", muleContext);
        msg.setOutboundProperty("where", (Object)"client");
        RootIDGatherer.process((MuleMessage)msg);
        client.send("vm://vmin", (MuleMessage)msg);
        Thread.sleep(1000L);
        Assert.assertEquals((long)6L, (long)RootIDGatherer.getMessageCount());
        Assert.assertEquals((long)1L, (long)RootIDGatherer.getIds().size());
    }

    static class RootIDGatherer
    extends AbstractMessageTransformer {
        static int messageCount;
        static Map<String, String> idMap;
        static int counter;

        RootIDGatherer() {
        }

        public static void initialize() {
            idMap = new HashMap<String, String>();
            messageCount = 0;
        }

        public static synchronized void process(MuleMessage msg) {
            String id = msg.getMessageRootId();
            ++messageCount;
            String where = (String)msg.getOutboundProperty("where");
            if (where == null) {
                where = "location_" + counter++;
            }
            idMap.put(where, id);
        }

        public Object transformMessage(MuleMessage msg, String outputEncoding) {
            RootIDGatherer.process(msg);
            return msg.getPayload();
        }

        public static Set<String> getIds() {
            return new HashSet<String>(idMap.values());
        }

        public static int getMessageCount() {
            return messageCount;
        }

        public static Map<String, String> getIdMap() {
            return idMap;
        }
    }
}

