/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.session.DefaultMuleSession;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class PersistentStore6007TestCase
extends FunctionalTestCase {
    private static final Log log = LogFactory.getLog(PersistentStore6007TestCase.class);
    private Latch latch;

    protected String getConfigFile() {
        return "org/mule/issues/persistent-store-6007.xml";
    }

    protected MuleContext createMuleContext() throws Exception {
        this.setStartContext(false);
        return super.createMuleContext();
    }

    @Test
    public void testPersistentNonQueueStores() throws Exception {
        this.latch = new Latch();
        Component.latch = this.latch;
        PersistentObjectStore.addEvents(muleContext);
        muleContext.start();
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://input", (Object)"Hello", null);
        Assert.assertEquals((Object)"Hello", (Object)result.getPayload());
        Assert.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
    }

    public static class Component
    implements Callable {
        private static Set<String> payloads = new HashSet<String>();
        private static Latch latch;
        private static Object lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object onCall(MuleEventContext eventContext) throws Exception {
            Object object = lock;
            synchronized (object) {
                String payload = eventContext.getMessageAsString();
                payloads.add(payload);
                log.warn((Object)("Saw new payload: " + payload));
                log.warn((Object)("Count is now " + payloads.size()));
                if (payloads.size() == 4) {
                    latch.countDown();
                }
                return eventContext.getMessage().getPayload();
            }
        }

        static {
            lock = new Object();
        }
    }

    public static class PersistentObjectStore
    implements ListableObjectStore<Serializable> {
        private static Map<Serializable, Serializable> events = new HashMap<Serializable, Serializable>();

        static void addEvents(MuleContext context) {
            for (String str : new String[]{"A", "B", "C"}) {
                DefaultMuleMessage msg = new DefaultMuleMessage((Object)str, context);
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)msg, MessageExchangePattern.ONE_WAY, null, (MuleSession)new DefaultMuleSession());
                events.put(AsynchronousUntilSuccessfulProcessingStrategy.buildQueueKey((MuleEvent)event), (Serializable)event);
            }
        }

        public void open() throws ObjectStoreException {
        }

        public void close() throws ObjectStoreException {
        }

        public synchronized List<Serializable> allKeys() throws ObjectStoreException {
            return new ArrayList<Serializable>(events.keySet());
        }

        public synchronized boolean contains(Serializable key) throws ObjectStoreException {
            return events.containsKey(key);
        }

        public synchronized void store(Serializable key, Serializable value) throws ObjectStoreException {
            events.put(key, value);
        }

        public synchronized Serializable retrieve(Serializable key) throws ObjectStoreException {
            return events.get(key);
        }

        public synchronized Serializable remove(Serializable key) throws ObjectStoreException {
            return events.remove(key);
        }

        public synchronized void clear() throws ObjectStoreException {
            events.clear();
        }

        public boolean isPersistent() {
            return true;
        }
    }
}

