/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.functional;

import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;

public class XStreamAdditionalConvertersTestCase
extends AbstractServiceAndFlowTestCase {
    private CountDownLatch latch = new CountDownLatch(1);

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/module/xml/xstream-additional-converters-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/module/xml/xstream-additional-converters-flow.xml"});
    }

    public XStreamAdditionalConvertersTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent("ObjectToXml");
        Assert.assertNotNull((Object)testComponent);
        testComponent.setEventCallback((EventCallback)new Callback(this.latch));
    }

    @Test
    public void testAdditionalConverters() throws Exception {
        ISO8601DateConverter converter = new ISO8601DateConverter();
        String timestamp = converter.toString((Object)new Date(System.currentTimeMillis()));
        String input = "<test-bean><createDate>" + timestamp + "</createDate></test-bean>";
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://FromTest", (Object)input, null);
        Assert.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
    }

    public static class TestBean {
        private Date createDate = null;

        public Date getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(Date createDate) {
            this.createDate = createDate;
        }
    }

    private static class Callback
    implements EventCallback {
        private CountDownLatch testLatch;

        public Callback(CountDownLatch latch) {
            this.testLatch = latch;
        }

        public void eventReceived(MuleEventContext context, Object component) throws Exception {
            Object payload = context.getMessage().getPayload();
            Assert.assertTrue((boolean)(payload instanceof TestBean));
            Assert.assertNotNull((Object)((TestBean)payload).getCreateDate());
            this.testLatch.countDown();
        }
    }
}

