/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.xml.functional.AbstractXmlFunctionalTestCase;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class XmlFilterFunctionalTestCase
extends AbstractXmlFunctionalTestCase {
    public static final int MAX_COUNT = 100;
    public static final String STRING_MESSAGE = "Hello world";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/module/xml/xml-filter-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/module/xml/xml-filter-functional-test-flow.xml"});
    }

    public XmlFilterFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testNotXml() throws Exception {
        this.logger.debug((Object)"not xml");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("in", (Object)STRING_MESSAGE, null);
        MuleMessage response = client.request("notxml", 3000L);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPayload());
        Assert.assertEquals((Object)STRING_MESSAGE, (Object)response.getPayloadAsString());
    }

    @Test
    public void testOther() throws Exception {
        this.logger.debug((Object)"other");
        this.doTestXml("other", this.getResourceAsString("org/mule/issues/many-sends-mule-1758-test-service.xml"));
    }

    @Test
    public void testSelf() throws Exception {
        this.logger.debug((Object)"self");
        this.doTestXml("self", this.getConfigAsString());
    }

    public void doTestXml(String endpoint, String xml) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("in", (Object)xml, null);
        MuleMessage response = client.request(endpoint, 6000L);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPayload());
        Assert.assertEquals((Object)xml, (Object)response.getPayloadAsString());
    }

    @Test
    public void testMany() throws Exception {
        Random random = new Random();
        block5: for (int i = 0; i < 100; ++i) {
            switch (random.nextInt(3)) {
                case 0: {
                    this.testNotXml();
                    continue block5;
                }
                case 1: {
                    this.testOther();
                    continue block5;
                }
                case 2: {
                    this.testSelf();
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Bad case");
                }
            }
        }
    }
}

